<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class RuleItem
{

    protected $p_id;
    protected $rr_name;
    protected $rr_info;
    protected $rr_id;
    protected $rr_insert;
    protected $rr_update;
    protected $rr_last_edit_user;
    protected $rr_parent;
    protected $rr_child;
    protected $rr_data_file;

    public function __construct($arr = array())
    {
        if (!is_array($arr)) {
            return;
        }

        foreach ($arr as $k => $v)
            $this->$k = $v;
    }

    public function __set($name, $value)
    {
        $name = strtolower($name);
        if (!is_numeric($name)) {
            $this->$name = $value;
        }
    }

    public function __get($name)
    {

        return $this->$name;
    }

    public function checkSubProzessRulesWithBooking($client, $booking)
    {


        $errors = array();
        $stat = new stdClass();
        $val = null;

        $rulesEngine = new Rulas2_RulesEngine_Handle($client, $this->rr_data_file);

        $core = $booking->coreData->getData();
        $hotel = $booking->hotelData->getData();
        #$participants = $booking->participants;

        unset($core['config']);

        if (is_array($core) && count($core)) {
            foreach ($core as $key => $value) {
                if ($key == "TRIM(SUBSTR(FLI_FLIGHTAIRLINE,INSTR(FLI_FLIGHTAIRLINE,',')+1))") {
                    $key = "TRIM(SUBSTR(FLI_FLIGHTAIRLINE,INSTR(FLI_FLIGHTAIRLINE,',')+1))";
                }

                if ($key == "vt_bo_end") {
                    $rulesEngine->addNewParam("VT_BO_BEGINN + VT_BO_DURATION", $value);
                } else {
                    $rulesEngine->addNewParam(trim($key), $value);
                }
            }

            if ($booking->coreData->vt_bo_bookingtype == 'P' && count($hotel) > 0) {
                foreach ($hotel as $keyH => $valueH) {
                    $rulesEngine->addNewParam(trim($keyH), $valueH);
                }
            }

            $value = $rulesEngine->getRula2ConditionSet();
            $errors = $rulesEngine->getErrorResult();
        }

        if ($value == true) {
            if (!class_exists('DB', false)) {
                Zend_Registry::get('log')->info('Buchung trifft zu und wird verarbeitet. bo_id:: ' . $booking->coreData->vt_bo_id . " -- proc:: $this->p_id");
            }

            $stat->result = TRUE;
        } else {
            if (!class_exists('DB', false)) {
                Zend_Registry::get('log')->err('Rules fehlgeschlagen. Buchung wird net weitergegeben. bo_id:: ' . $booking->coreData->vt_bo_id . " -- proc:: $this->p_id ARR::" . print_r($errors, true));
            }
            $stat->result = FALSE;
            $stat->message = $errors;
        }
        return $stat;
    }
}
