<?php

namespace Booking;


/**
 * *
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 * /
 */

use Rula2Std;

class BookingZgMeldung extends Rula2Std
{
    const ZG_CONFS_TABLE = "vt_zgconfs";
    const ZG_HISTORY_TABLE = "vt_zgemailhist";

    public function __construct()
    {
        parent::init();
    }

    /**
     * @param array $data
     * @return bool
     */
    public function insertIntoZgConfs($data)
    {
        $this->db->autoexecute(self::ZG_CONFS_TABLE, $data, 'INSERT');
        if ($this->db->errorMsg()) {
            $this->log->error('Exception in ' . __METHOD__ . ' MSG::' . $this->db->errorMsg());
            return false;
        }
        return true;
    }

    /**
     * @param array $data
     * @return bool
     */
    public function insertIntoZgHistory($data)
    {
        $this->db->autoexecute(self::ZG_HISTORY_TABLE, $data, 'INSERT');

        if ($this->db->errorMsg()) {
            $this->log->error('Exception in ' . __METHOD__ . ' MSG::' . $this->db->errorMsg());
            return false;
        }

        return true;
    }

}
