<?php
/**
 * Created by PhpStorm.
 * User: s.nagel
 * Date: 03.07.2018
 * Time: 15:21
 */

class HtCategoryUtil
{
    /**
     * @var string
     */
    private $htCategory;

    /**
     * @param string $htCategory
     */
    public function __construct($htCategory)
    {
        $this->htCategory = $htCategory ? $htCategory : "";
    }

    /**
     * @return string
     */
    public function getAsStars()
    {
        $stars = '';
        if ($this->convertToNumber() == 0) {
            return $stars;
        }
        for ($i = 0; $i < $this->convertToNumber(); ++$i) {
            if ($i < $this->convertToNumber() - 1) {
                $stars .= '• ';
            } else {
                $stars .= '•';
            }
        }
        return $stars;
    }

    public function convertToNumber()
    {
        $lengthOfHtCategory = strlen($this->htCategory);
        if ($lengthOfHtCategory == 1) {
            return intval($this->htCategory);
        }
        return $this->convertToNumberFromHtCategoryWithDelimiter();
    }

    private function convertToNumberFromHtCategoryWithDelimiter()
    {
        $matches = array();
        preg_match('/(\d*,\d*)/', $this->htCategory, $matches);
        if (!empty($matches)) {
            $formattedNumberAsString = str_replace(",", ".", $matches[0]);
            $roundedNumberAsFloat = round(floatval($formattedNumberAsString), 0, PHP_ROUND_HALF_UP);
            return intval($roundedNumberAsFloat);
        }
        return 0;
    }
}