<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class Rule extends Rula2Std
{

    protected $table;
    private $pk;
    private $pk2;
    protected $searchvars;

    public function __construct()
    {

        $this->pk = 'R_ID';
        $this->pk2 = 'RR_DATA_FILE';
        $this->table = 'RULA2_RULE';
        $this->mapTable = 'RULA2_PROZESS_TO_RULE';
        $this->subSqlForWhere = array();
        $this->searchvars = array("VT_BO_ID", "SUBSTR(VT_BO_CUSTOMER_FIRSTNAME,0,1)||'. '||VT_BO_CUSTOMER_NAME",
            "TO_CHAR(VT_BO_BEGINN,'YYYY-MM-DD')", "VT_BO_DESTINATION", "HT_HOTELCODE", "HT_HOTELLOCATION");

        $this->dateUpTo = date('Y-m-d', mktime(0, 0, 0, 1, 1, date('Y') - 1));

        parent::init();
    }

    public function saveIntoMapTable($id, $xmlFileName)
    {

        if ($id == null || $id <= 0 || $id == '' || $xmlFileName == '' || $xmlFileName == null) {
            throw new Exception('Fehlende Parameter um Rule zum Prozess zuzuordnen');
        }
        $stmt = "Select RR_ID 
			 FROM $this->table 
			 where $this->pk2 = '$xmlFileName'";

        $res = $this->db->getOne($stmt);

        if ($res <= 0 || $res == '' || $res == null || $this->db->errorMsg()) {
            throw new Exception('Kann ID nicht ermitteln um in die MapTable zuschreiben. MSG::' . $this->db->errorMsg());
        }

        $this->db->BeginTrans;

        if (!$this->deleteFromTable($id)) {

            $this->db->RollBackTrans();
            throw new Exception('Fehler beim loeschen der Eintraege. MSG::' . $this->db->errorMsg());
        }

        $data['R_ID'] = $res;
        $data['P_ID'] = $id;

        $stat = $this->db->autoExecute($this->mapTable, $data, 'INSERT');

        if ($stat == false || $this->db->errorMsg()) {
            $this->db->RollBackTrans();
            throw new Exception('INSERT fehlgeschlagen. MSG::' . $this->db->errorMsg());
        }

        $this->db->commitTrans();
    }

    public function deleteFromTable($id)
    {

        if ($id <= 0 || $id == null || $id == '') {
            throw new Exception('Fehler beim loeschen der der Rules. Keine ID.');
        }
        $this->db->execute("Delete from $this->mapTable where P_ID = '$id'");

        if ($this->db->errorMsg()) {
            return false;
        }

        return true;
    }

    public function getSelectedRuleForProzess($id, $from = '')
    {
        try {

            if ($id == null || $id <= 0 || $id == '') {
                throw new Exception('Keine Id um Rule abzuholen');
            }

            $stmt = "Select * from $this->mapTable m ,$this->table t
                     where m.$this->pk = t.R$this->pk 
                     and m.P_ID = '$id'";

            $res = $this->db->getAll($stmt);

            if ($this->db->errorMsg()) {
                throw new Exception('Fehler beim holen der Rules fuer den Prozess');
            }
            if (!is_array($res)) {
                return;
            }
            foreach ($res as $i => $val) {
                if (strtoupper($from) == 'CMS') {
                    $obj[$val['RR_DATA_FILE']] = new RuleItem();
                } else {
                    $obj[$i] = new RuleItem();
                }
                if (!is_array($val)) {
                    continue;
                }
                foreach ($val as $key => $value) {
                    $temp = strtolower($key);
                    if (strtoupper($from) == 'CMS') {
                        $obj[$val['RR_DATA_FILE']]->$temp = $value;
                    } else {
                        $obj[$i]->$temp = $value;
                    }
                }
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
        return $obj;
    }

    public function getSelectedObjectFromFilename($filename)
    {
        if ($filename == null || is_numeric($filename) || $filename == '') {
            throw new Exeption('Kein Dateiname um Rule abzuholen');
        }

        try {

            $stmt = sprintf("Select * from $this->table where RR_DATA_FILE = '%s'", $filename);

            $res = $this->db->getRow($stmt);
            return new RuleItem($res);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    private function getSQLHeadForCMSList($data, $dbTables)
    {

        $sort = $data->field;
        $direction = $data->direction;

        if ($sort == 'VT_BO_ID') {
            $sort = 'b.VT_BO_ID';
        }
        if ($sort == null || $sort == '') {
            $sort = 'b.VT_BO_ID';
        }
        $stmt = "SELECT * FROM (
                    SELECT 
                    RANK() OVER(ORDER BY $sort $direction) BIS,
                    b.VT_BO_ID,
                    TO_CHAR(b.VT_BO_BEGINN,'DD.MM.YYYY') as VT_BO_BEGINN,
                    SUBSTR(b.VT_BO_CUSTOMER_FIRSTNAME,0,1)||'. '||VT_BO_CUSTOMER_NAME as VT_BO_CUSTOMER_NAME,
                    b.VT_BO_DESTINATION,
                    h.HT_HOTELCODE,
                    h.HT_HOTELLOCATION,
                    case when ac.LAND is not null then ac.LAND else ac1.LAND END as LAND,
                    h.HT_HOTELNAME,
                    b.VT_BO_STORNO
                    FROM VT_BOOKINGS b ";

        $stmt .= $this->getJoinForSql($dbTables);

        $stmt .= " WHERE ";

        return $stmt;
    }

    private function getSQLFooterForCMSList($stmt, $params)
    {

        if (($params->actPage == null && $params->actPage <= 1) && (int)Context::stepIn()->getVar('anz') <= 1) {
            $von = 1;
            $bis = self::$anzElemente;
        } else {
            if ((int)Context::stepIn()->getVar('anz') > 0) {
                $bis = (Context::stepIn()->getVar('anz') * self::$anzElemente);
                $von = $bis - self::$anzElemente + 1;
            } else {
                $bis = ($params->actPage * self::$anzElemente);
                $von = $bis - self::$anzElemente + 1;
            }
        }

        foreach ($this->subSqlForWhere as $value) {
            $stmt .= " " . $value . " ";
        }

        $stmt .= ") WHERE BIS BETWEEN $von AND $bis ";
        return $stmt;
    }

    private function getStmtData($stmt)
    {

        try {

            $res = $this->db->getAll($stmt);

            if ($this->db->ErrorMsg()) {

                throw new Exception('Fehler beim holen der Buchungsdaten fuer die rule.' . $this->db->errorMsg());
            }

            return $res;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    private function getJoinForSql($dbTables)
    {

        $stmt = "";

        if ($dbTables['VT_FLIGHTS'] == 1) {
            $stmt .= " LEFT JOIN VT_FLIGHTS f ON FLI_BO_ID = b.VT_BO_ID  AND (FLI_FLIGHTSEQMENT_NO = 1 OR FLI_FLIGHTSEQMENT_NO IS NULL) ";
        }
        if ($dbTables['VT_HOTELS'] == 1) {
            $stmt .= " LEFT JOIN VT_HOTELS h ON HT_BO_ID = b.VT_BO_ID AND (HT_HOTEL_NO = 1 OR HT_HOTEL_NO is null) 
                       LEFT JOIN AIRPORT_CODES ac on ac.LC = h.HT_DESTAIRPORT 
                       LEFT JOIN AIRPORT_CODES ac1 on ac1.LC = b.vt_bo_destination
                       LEFT JOIN VT_PACKAGETOURS p on (b.vt_bo_id = p.vt_bo_id and p.vt_pt_no = 1) ";
        }
        if ($dbTables['VT_FLIGHT_SAVED'] == 1) {
            $stmt .= " LEFT JOIN VT_FLIGHT_SAVED vfs ON vfs.VT_FLI_SV_ID = b.VT_BO_ID 
                       LEFT JOIN vt_flight_flighttype_ticket vfft on vfft.airline = vfs.vt_fli_sv_airline ";
            if (!$this->subSqlForWhere['VT_FLIGHT_SAVED']) {
                $this->subSqlForWhere['VT_FLIGHT_SAVED'] = " AND (vfs.VT_FLI_SV_NUMBER IS NULL OR vfs.VT_FLI_SV_NUMBER = (
								SELECT MIN(f2.VT_FLI_SV_NUMBER)
								FROM VT_FLIGHT_SAVED f2
								WHERE f2.VT_FLI_SV_ID = vfs.VT_FLI_SV_ID
								AND f2.VT_FLI_SV_STORNOFLAG = 0
								)) ";
            }
        }
        if ($dbTables['VT_HISTORY'] == 1) {
            $stmt .= " LEFT JOIN VT_HISTORY vh ON vh.HST_BO_ID = b.vt_bo_id ";

            if (!$this->subSqlForWhere['VT_HISTORY']) {
                $this->subSqlForWhere['VT_HISTORY'] = " AND (vh.HST_INSERT_TIMESTAMP IS NULL OR vh.HST_INSERT_TIMESTAMP = (
                                                            SELECT MAX(vh2.HST_INSERT_TIMESTAMP)
                                                            FROM VT_HISTORY vh2
                                                            WHERE vh2.HST_BO_ID = b.VT_BO_ID
							))";
            }
        }
        if ($dbTables['VT_RECLAMATION'] == 1) {
            $stmt .= " LEFT JOIN VT_RECLAMATION vtr ON vtr.VTR_BO_ID = b.VT_BO_ID AND vtr.VTR_NO = 0 ";
        }
        if ($dbTables['VT_RECLAMATION_COUPON']) {
            $stmt .= " LEFT JOIN VT_RECLAMATION_COUPON vrcp ON VRCP_BO_ID = b.VT_BO_ID  ";
        }
        if ($dbTables['VT_RECLAMATION_REFUND']) {
            $stmt .= " LEFT JOIN VT_RECLAMATION_REFUND vrr on vrr_bo_id = vrcp_bo_id and vrr_no = vrcp_no ";
        }
        if ($dbTables['VT_RULAS_SEND'] == 1) {
            $stmt .= " LEFT JOIN vt_rulas_send vtrs on vtrs.ru_bo_id = b.vt_bo_id ";
            if (!$this->subSqlForWhere['VT_RULAS_SEND']) {
                $this->subSqlForWhere['VT_RULAS_SEND'] = " AND (vtrs.RU_SEND_TIME IS NULL OR vtrs.RU_SEND_TIME = (
                                                                SELECT DISTINCT(MAX(RU_SEND_TIME)) 
                                                                FROM vt_rulas_send WHERE RU_BO_ID = vtrs.RU_BO_ID
                                                            ))";
            }
        }
        if ($dbTables['VT_BOOKINGS_PARAMETER'] == 1) {
            $stmt .= " LEFT JOIN vt_bookings_parameter vbp on vbp_bo_id = b.vt_bo_id ";
        }
        if ($dbTables['VT_FLIGHTS_HISTORY'] == 1) {
            $stmt .= " LEFT JOIN vt_flights_history vfh on vfh_bo_id = b.vt_bo_id ";
            if (!$this->subSqlForWhere['VT_FLIGHTS_HISTORY']) {
                $this->subSqlForWhere['VT_FLIGHTS_HISTORY'] =
                    " AND (vfh.VFH_FLIGHTINSERT IS NULL OR vfh.VFH_FLIGHTINSERT||vfh.VFH_FLIGHTSEQ = (
                                          SELECT DISTINCT(MAX(VFH_FLIGHTINSERT||VFH_FLIGHTSEQ)) 
                                          FROM VT_FLIGHTS_HISTORY 
                                          WHERE VFH_BO_ID = vfh.VFH_BO_ID
					))";
            }
        }
        if ($dbTables['VT_EFT_INVALID'] == 1) {
            $stmt .= " LEFT JOIN vt_eft_invalid vei on vei.vt_bo_id = b.vt_bo_id ";
            if (!$this->subSqlForWhere['VT_EFT_INVALID']) {
                $this->subSqlForWhere['VT_EFT_INVALID'] = " AND (vei.CREATED IS NULL OR vei.CREATED = (
								SELECT (MAX(vei2.CREATED)) 
								FROM VT_EFT_INVALID vei2 WHERE vei2.VT_BO_ID = vei.VT_BO_ID
                                                            ))";
            }
        }
        if ($dbTables['VT_CC_GUWID'] == 1) {
            $stmt .= " left join vt_cc_guwid vcc on vcc.vt_bo_id = b.vt_bo_id ";
            if (!$this->subSqlForWhere['VT_CC_GUWID']) {
                $this->subSqlForWhere['VT_CC_GUWID'] = " AND (vcc.INSERT_TIME IS NULL OR vcc.INSERT_TIME = (
                                                            SELECT (MAX(vcc2.INSERT_TIME)) 
                                                            FROM VT_CC_GUWID vcc2 WHERE vcc2.VT_BO_ID = vcc.VT_BO_ID
							))";
            }
        }

        if ($dbTables['VT_DUNNINGS'] == 1) {
            $stmt .= " left join vt_dunnings vdd on vdd.vt_bo_id = b.vt_bo_id ";
            if (!$this->subSqlForWhere['VT_DUNNINGS']) {
                $this->subSqlForWhere['VT_DUNNINGS'] = " AND (vdd.DUN_TIMESTAMP IS NULL OR vdd.DUN_TIMESTAMP = (
                                                            select max(dun_timestamp) from vt_dunnings vdd1
                                                            where vdd1.vt_bo_id = vdd.vt_bo_id
                                                       ))";
            }
        }

        if ($dbTables['VT_BOOKINGS_CHECKINDATA'] == 1) {
            $stmt .= " left join vt_bookings_checkindata vbc on vbc.vbc_bo_id = b.vt_bo_id ";

        }

        if ($dbTables['VT_BONITATSPRUEFUNG'] == 1) {
            $stmt .= " left join vt_bonitatspruefung vbpr on vbpr.vt_bo_id = b.vt_bo_id ";
        }

        if ($dbTables['ZAHLUNGSIMPORT_ITEM'] == 1) {
            $stmt .= " left join zahlungsimport_item zi on zi.vt_bo_id = b.vt_bo_id ";
        }

        if ($dbTables['VT_EXCHANGE_RATES_LIST'] == 1) {
            $stmt .= " left join vt_exchange_rates_list er on er.er_bo_id = b.vt_bo_id ";
        }

        return $stmt;
    }

    public function generateSqlFromXmlFromApp(RuleItem $obj)
    {
        try {
            $this->rulesIni = new Zend_Config_Ini(Zend_Registry::get('config')->configs->rula2rules);

            $xmlFile = $this->rulesIni->dir . $obj->rr_data_file;

            if (!is_file($xmlFile) || filetype($xmlFile) != 'file' || substr($xmlFile, -3) != 'xml') {
                throw new Exception('Kein File oder keine XML Datei um SQL zugenerieren. RULE_ID ::' . $obj->rr_id);
            }

            $generateObj = new Rulas2_RulesEngine_GenerateSql();

            $generateObj->startToGenerateXml(file_get_contents($xmlFile));

            $bookingCoreSql = new Booking_BookingSql();

            $temp = new stdClass();

            $tables = $generateObj->getTables();

            if (!$tables['VT_HOTELS']) {
                $tables['VT_HOTELS'] = 1;
            }
            if (!$tables['VT_FLIGHTS']) {
                $tables['VT_FLIGHTS'] = 1;
            }
            if (!$tables['VT_EXCHANGE_RATES_LIST']) {
                $tables['VT_EXCHANGE_RATES_LIST'] = 1;
            }
            $temp->sql = $generateObj->getSql();
            $temp->joins = $this->getJoinForSql($tables);
            $temp->special = $this->subSqlForWhere;
            $temp->tables = $generateObj->getTables($tables);

            $res = $bookingCoreSql->getCoreData(null, null, $temp);

            return $res;
        } catch (Exception $e) {
            throw new Exception("Fehler beim holen der DB Abfrage fuer den HP.MSG::" . $e->getMessage() . " RULE_ID::" . $obj->rr_id);
        }
    }

    public function generateSqlFromXml($objArray, $from = 'cms')
    {
        try {
            if ($from == 'cms') {

                $this->searchvars = array(
                    "VT_BO_ID",
                    "SUBSTR(VT_BO_CUSTOMER_FIRSTNAME,0,1)||'.'||VT_BO_CUSTOMER_NAME",
                    "TO_CHAR(VT_BO_BEGINN,'YYYY-MM-DD')",
                    "VT_BO_DESTINATION",
                    "HT_HOTELCODE",
                    "HT_HOTELLOCATION",
                    "HT_HOTELNAME"
                );

                $params = $this->getFilterAndPaging();
            }

            if (!is_array($objArray)) {
                return true;
            }

            foreach ($objArray as $xmlName => $obj) {

                if (!($obj instanceof RuleItem)) {
                    throw new Exception('Kein oder falsches Objekt uebermittelt um SQL zu generieren');
                }

                $temp['xml'] = $obj->rr_data_file;


                try {
                    $anfrage = curl_init($this->ini->cfg('VTOURS_WS_URL') . "/rulas2/Webservice/generate/");
                    curl_setopt($anfrage, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($anfrage, CURLOPT_POSTFIELDS, $temp);
                } catch (Exception$e) {
                    throw new Exception('Fehler beim holen der Daten fuer den SQL');
                }
                $data = unserialize(curl_exec($anfrage));

                if (!$data->tables) {
                    throw new Exception('Tabellen nicht erhalten im ' . __METHOD__ . ' (Keine Tabellen vom WS)');
                }

                if (!$data->sql) {
                    throw new Exception('Teilsql nicht erhalten im ' . __METHOD__ . ' (Keine Daten vom WS)');
                }

                if (!$data->tables['VT_HOTELS']) {
                    $data->tables['VT_HOTELS'] = 1;
                }
                if (!$data->tables['VT_FLIGHTS']) {
                    $data->tables['VT_FLIGHTS'] = 1;
                }

                $stmt = $this->getSQLHeadForCMSList($params, $data->tables) . " " . $data->sql;

                $stmt = $this->getSQLFooterForCMSList($stmt, $params);

                //echo $stmt;

                $anzData = $this->getCountBookings($data->sql, $data->tables);

                self::$anzElemente = $anzData;

                $res = $this->getStmtData($stmt);

                $res['anzData'] = $anzData;
            }
            return $res;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function getAnzInPage()
    {

        return self::$anzElemente;
    }

    private function getCountBookings($stmtFooter, $dbTables)
    {

        try {
            $stmt = "SELECT COUNT(*)
                     FROM VT_BOOKINGS b";

            $stmt .= $this->getJoinForSql($dbTables);
            $stmt .= "WHERE to_char(vt_bo_beginn,'YYYY-MM-DD') > '$this->dateUpTo' AND ";
            $stmt .= $stmtFooter;

            foreach ($this->subSqlForWhere as $value) {
                $stmt .= " " . $value . " ";
            }

            $res = $this->db->getOne($stmt);

            if ($this->db->errorMsg()) {

                throw new Exception('Fehler beim holen der gesamt Anzahl der Buchungen MSG::' . $this->db->errorMsg());
            }

            return $res;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

}