<?php

namespace Vtours\Rula2Engine;

/**
 * *
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 * /
 */


/**
 * Class Map
 */
class Map extends Rula2Std
{

    public static $instance = null;
    private $process;
    private $container;
    private $containerObjToSearch = array();
    private $prozessObjToSearch = array();
    private $map = array();
    private $storeProzessesInContainer = array();
    private $navigateContainer = array();
    public $error = array();
    public $prozessesToCheck = array();
    public $checkValues = array();
    public $startingProzesses = array();
    public $standArtProzesse = array();

    const STR_CONTAINER = 'container';
    const STR_START = 'start';
    const STR_PROZESS = 'prozess';
    const KEY_MAINPROCESS_ID = 'HPR_ID';

    /**
     * @return Map|Rula2Std|null
     */
    public static function getInstance()
    {

        if (self::$instance == null) {
            return new self;
        }

        return self::$instance;
    }

    /**
     * Map constructor.
     */
    public function __construct()
    {

        $engine = new Rula2Engine();
        $this->process = $engine->getProzessInstance();
        $this->container = $engine->getContainerInstance();
        parent::init();
        self::$instance = self;
    }

    /**
     * @param int $id
     * @return array
     * @throws Exception
     */
    public function getProzessStoreInformationForFirstContainer($id)
    {

        if ($id < 0 || $id == null || $id == '') {
            throw new Rulas2Exception('Keine Id um Prozess Infos zuspeichern.');
        }

        try {
            if (count($this->storeProzessesInContainer) <= 0) {
                $this->generateProcessMap($id, self::STR_START);
            }
        } catch (Exception $e) {
            throw new Rulas2Exception('Fehler bei StoreProzessInformation :: ID' . $e->getMessage());
        }
        return $this->storeProzessesInContainer;
    }

    /**
     * @param int $cid
     * @return array
     * @throws Exception
     */
    public function getContainerObject($cid)
    {
        if ($cid < 0) {
            throw new Rulas2Exception('Keine Id um den Container zuholen');
        }

        return $this->navigateContainer[$cid];
    }

    /**
     * @return array
     */
    public function getCurrentMap()
    {
        return $this->map;
    }

    /**
     * @param int $id
     * @param string $stat
     * @return array
     * @throws Exception
     */
    public function generateProcessMap($id, $stat = self::STR_START)
    {
        try {

            if ($stat === self::STR_START) {
                $this->addStartProcessToMap($id);
                if (count($this->prozessObjToSearch) <= 0) {
                    return $this->map;
                } else {
                    $this->generateProcessMap(array_pop($this->prozessObjToSearch), self::STR_PROZESS);
                }
            }

            if ($stat == self::STR_PROZESS) {
                $this->addProcessToProcessMap($id);
                if (count($this->containerObjToSearch) > 0) {
                    $this->generateProcessMap(array_pop($this->containerObjToSearch), self::STR_CONTAINER);
                } elseif (count($this->containerObjToSearch) <= 0 && count($this->prozessObjToSearch) > 0) {
                    $this->generateProcessMap(array_pop($this->prozessObjToSearch), self::STR_PROZESS);
                }
            }

            if ($stat == self::STR_CONTAINER) {
                $this->addContainerToProcessMap($id);
                if (count($this->prozessObjToSearch) > 0) {
                    $this->generateProcessMap(array_pop($this->prozessObjToSearch), self::STR_PROZESS);
                } elseif (count($this->prozessObjToSearch) <= 0 && count($this->containerObjToSearch) > 0) {
                    $this->generateProcessMap(array_pop($this->containerObjToSearch), self::STR_CONTAINER);
                }
            }

            return $this->map;
        } catch (Exception $e) {
            throw new Rulas2Exception($e->getMessage());
        }
    }

    public function reset()
    {
        $this->map = array();
        $this->storeProzessesInContainer = array();
    }

    /**
     * @param array $prozessToInsert
     * @param array $dataPost
     * @return bool
     * @throws Exception
     */
    public function CheckIfItsToInsert($prozessToInsert, $dataPost)
    {

        $ids = $this->getProzessStoreInformationForFirstContainer($dataPost[self::KEY_MAINPROCESS_ID]);

        $navElement = $this->getContainerObject($dataPost['C_ID']);
        $this->reset();

        $mapProzessAdd = $this->generateProcessMap($prozessToInsert);
        $this->getProzessIdsFromMap($mapProzessAdd);
        $this->reset();

        if (!$this->checkNavigationTrees($navElement, $ids, $prozessToInsert)) {
            return false;
        }

        $this->checkInOtherProzesses($dataPost, self::STR_START);

        if (!$this->checkArray($this->startingProzesses)) {
            return $this->checkNavigationTrees($navElement, $ids, $prozessToInsert);
        }

        foreach ($this->startingProzesses as $proc) {
            if ($proc != $dataPost[self::KEY_MAINPROCESS_ID]) {
                $this->reset();
                $this->generateProcessMap($proc);
                $navElement = $this->getContainerObject($dataPost['C_ID']);
                $idsNavToAdd = $this->getProzessStoreInformationForFirstContainer($proc);
                if (!$this->checkNavigationTrees($navElement, $idsNavToAdd, $prozessToInsert, 'NOR')) {
                    return true;
                }
            }
        }

        return $this->checkNavigationTrees(
            $navElement,
            $idsNavToAdd,
            $prozessToInsert,
            'AND'
        );

    }

    /**
     * @param int $nav
     * @param int $ids
     * @param int $id
     * @return bool
     */
    public function checkNavigationTree($nav, $ids, $id)
    {

        if (is_array($ids) && count($ids) == 0) {
            return true;
        }

        foreach ($id as $prozessInsert) {

            foreach ($nav as $navi) {

                if (stristr($navi->navElements, '.')) {
                    $tmp = explode('.', $navi->navElements);
                    $ebene = $tmp[0];
                } else {
                    $ebene = $navi->navElements;
                }

                if (!$ids[$ebene]) {
                    continue;
                }

                foreach ($ids[$ebene] as $navigation => $prozess) {
                    $length = strlen($navigation);
                    if ($prozessInsert == $prozess && $navigation == substr($navi->navElements, 0, $length)) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /**
     * @param array $maps
     */
    public function getProzessIdsFromMap($maps)
    {

        if (!is_array($maps)) {
            return;
        }
        foreach ($maps as $map) {
            if ($map instanceof MapProzessItem) {
                array_push($this->prozessesToCheck, $map->pr_id);
            }
        }

        if ($map->nextElement != null || $map->nextElement != '') {
            $this->getProzessIdsFromMap($map->nextElement);
        } else {
            return;
        }
    }

    /**
     * @param array $data
     * @param string $mode
     * @return bool|void
     * @throws Exception
     */
    public function checkInOtherProzesses($data, $mode)
    {

        try {
            $stmt = "SELECT RC_ID 
                     FROM RULAS2_CONTAINER_TO_PROZESS 
                     WHERE P_ID = '" . $data[self::KEY_MAINPROCESS_ID] . "'";

            $res = $this->db->getAll($stmt);

            if ($this->db->errorMsg()) {
                throw new Rulas2Exception($this->db->errorMsg());
            }

            if (($res == null || $res == '' || count($res) <= 0) && $mode == self::STR_START) {
                return true;
            }

            if (($res == null || $res == '' || count($res) <= 0) && $mode == null) {
                // Der Prozess muss ueberprueft werden. Ob das hinzufuegen keine Endlos schleife liefert
                array_push($this->startingProzesses, $data[self::KEY_MAINPROCESS_ID]);
            }
            if (is_array($res) && count($res) > 0) {

                foreach ($res as $dataDb) {

                    $stmt1 = "SELECT P_ID FROM RULA2_PROZESS_TO_CONTAINER WHERE RC_ID = '" . $dataDb['RC_ID'] . "'";

                    $res1 = $this->db->getAll($stmt1);

                    if ($this->db->errorMsg) {
                        throw new Rulas2Exception($this->db->errorMsg());
                    }

                    if ($res1 == null || $res1 == '') {
                        continue;
                    }

                    foreach ($res1 as $proc) {
                        if ((int)$proc['P_ID'] > 0) {
                            $data[self::KEY_MAINPROCESS_ID] = $proc['P_ID'];
                            $this->checkInOtherProzesses($data, null);
                        } else {
                            throw new Rulas2Exception('Fehler beim ueberpruefen');
                        }
                    }
                }
            }
        } catch (Exception $e) {
            throw new Rulas2Exception('Fehler in der DB Abfrage. MSG::' . $this->db->errorMsg());
        }
        $this->startingProzesses = array_unique($this->startingProzesses);

        foreach ($this->startingProzesses as $keyParent => $procParent) {
            foreach ($this->prozessesToCheck as $procChecked) {

                if ($procChecked == $procParent) {
                    unset($this->startingProzesses[$keyParent]);
                }
            }
        }
        ksort($this->startingProzesses);

        return;
    }

    /**
     * @param array $data
     */
    private function checkMap($data)
    {


        if (!is_array($data)) {
            return;
        }

        foreach ($data as $map) {

            if ($map->nextElement == null || $map->nextElement == '') {
                return;
            } else {

                if ($map instanceof MapProzessItem && (!key_exists($map->p_id, $this->checkValues))) {
                    $this->checkValues[$map->p_id] = $map;
                }

                $this->checkMap($map->nextElement);
            }

            return;
        }
    }

    /**
     * @return array
     */
    public function getStandartProzesse()
    {
        return $this->standArtProzesse;
    }

    /**
     * @param int $id
     * @return mixed
     */
    public function getStandartProzessById($id)
    {

        return $this->standArtProzesse[$id];
    }

    /**
     * @param $id
     * @return bool
     */
    public function isDeclaredAsStandartProzess($id)
    {
        if ($this->standArtProzesse[$id]) {
            return true;
        }
        return false;
    }

    /**
     * @param int $id
     * @return array|void
     * @throws Exception
     */
    private function addStartProcessToMap($id)
    {
        $res = $this->container->getContainerForProzessId($id);

        if (count($res) <= 0 || !is_array($res)) {
            return;
        }

        foreach ($res as $key => $value) {
            try {
                $obj = new MapContainerItem($value);
                $obj->parentProcess = $obj->p_id;
                $obj->navElement = $key;
                $obj->nextElement = array();
                if ($obj->rc_std_process > 0) {
                    $elem = $this->process->getProzessById($obj->rc_std_process);
                    if ($elem) {
                        $this->standArtProzesse[$obj->rc_std_process] = $elem;
                    }
                }
                array_push($this->map, $obj);
                if ($this->map[$key] != null && $this->map[$key] != '') {
                    array_push($this->prozessObjToSearch, $this->map[$key]);
                }

                $this->navigateContainer[$obj->rc_id][] = new stdClass();
                $lastElement = count($this->navigateContainer[$obj->rc_id]) - 1;
                $this->navigateContainer[$obj->rc_id][$lastElement]->navElements = $obj->navElement;
            } catch (Exception $e) {
                $this->error[] = 'Fehler beim erstellen der Container klasse fuer. ' . $obj->rc_id;
                continue;
            }
        }
    }

    /**
     * @param stdClass $id
     * @throws Exception
     */
    private function addProcessToProcessMap($id)
    {

        $res = $this->container->getProzessesOfContainer($id->rc_id);

        foreach ($res as $key => $value) {
            try {
                $obj = new MapProzessItem($value);
                $obj->parentContainer = $id->rc_id;
                $obj->nextElement = array();

                $temp = explode(".", $id->navElement);

                foreach ($temp as $key => $value) {

                    if ($key == 0) {
                        $data = $this->map[$value];
                        $firstElement = $data->navElement;
                    } else {
                        $data = $data->nextElement[$value];
                    }
                }
                $obj->navElement = $id->navElement . "." . count($data->nextElement);
                array_push($data->nextElement, $obj);
                array_push($this->containerObjToSearch, $obj);
                $this->storeProzessesInContainer[$firstElement][$obj->navElement] = $obj->p_id;
            } catch (Exception $e) {
                $this->error[] = 'Fehler beim erstellen der Prozess Objektes.ID :: ' . $obj->p_id;
                continue;
            }
        }
    }

    /**
     * @param stdClass $id
     * @throws Exception
     */
    private function addContainerToProcessMap($id)
    {
        $res = $this->container->getContainerForProzessId($id->p_id);

        foreach ($res as $key => $value) {
            try {
                $obj = new MapContainerItem($value);
                $obj->parentProcess = $id->p_id;
                $obj->nextElement = array();

                $temp = $obj;

                $temp = explode('.', $id->navElement);

                foreach ($temp as $key => $value) {

                    if ($key == 0) {
                        $data = $this->map[$value];
                    } else {
                        $data = $data->nextElement[$value];
                    }
                }
                if ($obj->rc_std_process > 0) {
                    $this->standArtProzesse[$obj->rc_std_process]
                        = $this->process->getProzessById($obj->rc_std_process);
                }
                $obj->navElement = $id->navElement . "." . count($data->nextElement);
                $this->navigateContainer[$obj->rc_id][]->navElements = $obj->navElement;

                array_push($data->nextElement, $obj);
                array_push($this->prozessObjToSearch, $obj);
            } catch (Exception $e) {
                $this->error[] = 'Fehler beim erzeugen der Container Obejktes. ID.' . $obj->rc_id;
                continue;
            }
        }
    }

    /**
     * @param array $data
     * @return bool
     */
    private function checkArray($data)
    {
        if (!is_array($data) || count($data) <= 0) {
            return false;
        }

        return true;
    }

    /**
     * @param int $navElement
     * @param array $ids
     * @param int $prozessToInsert
     * @param string $type
     * @return bool
     */
    private function checkNavigationTrees($navElement, $ids, $prozessToInsert, $type = 'NOR')
    {
        $stat1 = $this->checkNavigationTree($navElement, $ids, [0 => $prozessToInsert]);
        $stat2 = $this->checkNavigationTree($navElement, $ids, $this->prozessesToCheck);

        if ($type == 'NOR' && (!$stat1 || !$stat2)) {
            return false;
        }

        if ($type == 'AND' && $stat1 && $stat2) {
            return true;
        }

        return $type == 'NOR' ? 1 : 0;
    }
}
