<?php

namespace Vtours\Rula2Engine;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class Glossar extends Rula2Std
{
    private $table;
    private $pk;
    private $ldelim = '';
    private $rdelim = '';
    private $std_ldelim = '[{';
    private $std_rdelim = '}]';
    private $acc_ldelim = '{';
    private $acc_rdelim = '}';
    private $cms_ldelim = '[{';
    private $cms_rdelim = '}]';

    public function __construct()
    {

        $this->table = "RULA2_GLOSSAR";
        $this->pk = "RG_ID";
        $this->setStandardDelimiter();
        parent::init();
    }

    public function getAllValues($currentTemplateId = 0)
    {
        try {
            $stmt = "select * from $this->table order by RG_TABLE, RG_LABEL asc";

            $res = $this->db->getAll($stmt);

            if ($this->db->errorMsg()) {
                throw new Exception('Fehler in der Abfrage um Glossardaten zu holen. MSG::' . $this->db->errorMsg());
            }

            $obj = array();
            if (count($res) > 0) {
                foreach ($res as $anz => $item) {
                    #if($item['RG_TABLE'] == 'VT_FLIGHTS') { continue; }
                    if ($this->_getMappedTablename($item['RG_TABLE']) == $item['RG_TABLE']) {
                        continue;
                    }

                    if (!array_key_exists($item['RG_TABLE'], $obj)) {
                        $obj[$item['RG_TABLE']] = array(
                            'name' => $this->_getMappedTablename($item['RG_TABLE']),
                            'items' => array()
                        );
                    }
                    $g_item = new GlossarItem();
                    //__print($item);
                    foreach ($item as $k => $v) {
                        $key = strtolower($k);
                        if ($item['RG_CONST'] == 1) {
                            $val = $item['RG_VALUE'];
                            $g_item->$key = $val;
                        } else {
                            $g_item->$key = $key == 'rg_variable' ? $this->ldelim . '$' . strtolower($v) . $this->rdelim : $v;
                        }
                    }
                    $obj[$item['RG_TABLE']]['items'][] = $g_item;
                }
            }

            //Jetzt noch die Templates, die als Variablen angelegt wurden
            $stmt = "select * from RULA2_TEMPLATE where RT_EMAILTYP = 'VARIABLE'";
            $res = $this->db->getAll($stmt);

            if (count($res) > 0) {
                foreach ($res as $k => $item) {
                    #__print($item);
                    if (!array_key_exists('TPL_VARIABLES', $obj)) {
                        $obj['TPL_VARIABLES'] = array(
                            'name' => $this->_getMappedTablename('TPL_VARIABLES'),
                            'items' => array()
                        );
                    }
                    $g_item = new GlossarItem();
                    $g_item->rg_label = $item['RT_NAME'];
                    $g_item->rg_variable = $this->ldelim . '$tpl_' . $item['RT_ID'] . $this->rdelim;
                    #__print($g_item);
                    $obj['TPL_VARIABLES']['items'][] = $g_item;
                }
            }
            //Prozessvariablen. Nur sichtbar, wenn im Subprozess oder Hauptprozess selektiert ist.
            $stmt = "select * from RULA2_TEMPLATE where RT_EMAILTYP = 'PVARIABLE'";
            $res = $this->db->getAll($stmt);

            if (count($res) > 0) {
                foreach ($res as $k => $item) {
                    #__print($item);
                    if (!array_key_exists('PTPL_VARIABLES', $obj)) {
                        $obj['PTPL_VARIABLES'] = array(
                            'name' => $this->_getMappedTablename('PTPL_VARIABLES'),
                            'items' => array()
                        );
                    }
                    $g_item = new GlossarItem();
                    $g_item->rg_label = $item['RT_NAME'];
                    $g_item->rg_variable = $this->ldelim . '$ptpl_' . $item['RT_ID'] . $this->rdelim;
                    #__print($g_item);
                    $obj['PTPL_VARIABLES']['items'][] = $g_item;
                }
            }
            return $obj;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function setLdelim($str)
    {
        $this->ldelim = $str;
    }

    public function setRdelim($str)
    {
        $this->rdelim = $str;
    }

    public function setStandardDelimiter()
    {
        $this->ldelim = $this->std_ldelim;
        $this->rdelim = $this->std_rdelim;
    }

    public function getStandardDelimiter()
    {
        return array(
            'left' => $this->std_ldelim,
            'right' => $this->std_rdelim,
        );
    }

    public function getAccountingDelimiter()
    {
        return array(
            'left' => $this->acc_ldelim,
            'right' => $this->acc_rdelim,
        );
    }

    public function getCmsDelimiter()
    {
        return array(
            'left' => $this->cms_ldelim,
            'right' => $this->cms_rdelim,
        );
    }

    private function _getMappedTablename($key)
    {
        $name = array(
            'VT_BOOKINGS' => 'Buchung',
            'VT_CUSTOMER' => 'Kunde',
            'VT_FLIGHT_SAVED' => 'Flug',
            'VT_HOTELS' => 'Hotel',
            'VT_HOTEL_ADDRESS' => 'Hotel Adresse',
            'ZOPTIONS' => 'Sonstiges',
            'TPL_VARIABLES' => 'Template Variablen',
            'PTPL_VARIABLES' => 'Prozess Variablen',
            'va' => 'Veranstalter',
            'RULA_INCOMING_AGENCIES' => 'hotelInc',
            'RULA_TRANSFER_AGENCIES' => 'transferAg',
            'Checkin' => 'Check In Daten',
            'PAYCODE' => 'Paycode Links',
            'VT_PRICECORRECTIONS_WATERPLANE' => 'Preiskorrektur',

                #'USER_AUTH'			=> 'Agency-Benutzer',
                #'VT_AGENCIES'			=> 'Agency',
                #'VT_FLIGHTS'			=> 'Flugzeiten',
                #'VT_FLIGHTTIMES'		=> 'Flugzeiten',
                #'VT_FLIGHT_ZG'			=> 'Flug ZG',
                #'VT_PACKAGETOURS'		=> 'O-Pauschal',
                #'VT_PARTICIPANTS'		=> 'Reiseteilnehmer',
        );

        return $name[$key] ? $name[$key] : $key;
    }
}
