<?php

namespace Vtours\Rula2Engine;

class History {
	protected $db;
	public static $instance = null;
	protected $_logAllowed = false;

	public static function getInstance() {
		if (self::$instance == null) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	
	public function __construct() {
		$this->db = \DB::stepIn();
		$this->_logAllowed = \Config::stepIn()->cfg('RULA2_HISTORY_ALLOWED') == '1' ? true : false;
		//echo ("log allowed: ".$this->_logAllowed);
	}
	
	/**
	 *
	 * @param type $type			: item type to log (process, rule, template...)
	 * @param type $id			: item id
	 * @param type $data			: current data to log (before changes)
	 * @param type $action		: action / method calling this
	 * @param type $usr			: user name - who makes changes?
	 * @return type 
	 */
	public function logChanges($type, $id, $action, $what, $usr, &$ext_data = null) {
		if(!$this->_logAllowed) return;
		if(!is_array($what)) return;
		
		$r2h_id = '';
		$stamp = explode(' ', microtime());
		$microsec = explode('.', $stamp[0]);
		$r2h_id = $stamp[1].'.' . substr($microsec[1], 0, -2);
		#__print($r2h_id);
		
		#return;
		$logdata = array();
		$this->engine = new Rula2Engine();
		$this->prozess = $this->engine->getProzessInstance();
		$this->map = $this->engine->getMapInstance();
		$this->templates = $this->engine->getTemplateInstance();
		$this->upload = $this->engine->getFileInstance();
		$this->options = $this->engine->getOptionsInstance();
		$this->action = $this->engine->getActionInstance();
		$this->rule = $this->engine->getRuleInstance();
		$this->scheduler = $this->engine->getSchedulerInstance();
		
		foreach($what as $w) {
			if($w == 'process' || $w == 'all') {
				$process = $this->prozess->getProzessById($id);
				$logdata['process'] = $process;
			}
			if($w == 'scheduler' || $w == 'all') {
				$scheduler = $this->scheduler->getSchedulerById($id);
				$logdata['scheduler'] = $scheduler;
			}
			if($w == 'options' || $w == 'all') {
				$options = $this->options->getOptionsOfProzess($id);
				if(is_array($options)) 
					$logdata = array_merge($logdata, $this->_castObjectsToArray($options, 'option'));
			}
			if($w == 'files' || $w == 'all') {
				$files = $this->upload->getUploadedFiles($id, 'process');
				if(!is_array($files) && $files === true)
					$files = array();
				if(count($files) > 0)
					$logdata = array_merge($logdata, $this->_castObjectsToArray($files, 'file'));
			}
			if($w == 'template_ids') {
				$templates = $this->templates->getTemplatesForProcess($id);
				$templates_ids = array();
				foreach($templates as $k => $v) {
					$templates_ids[] = $v->rt_id;
				}
				$logdata['template_ids'] = $templates_ids;
			}
			if($w == 'processtemplates' || $w == 'all') {
				$templates = $this->templates->getTemplatesForProcess($id);
				$logdata = array_merge($logdata, $this->_castObjectsToArray($templates, 'processtemplate'));
			}
			if($w == 'template') {
				$template = $this->templates->getTemplateById($id);
				$logdata = array_merge($logdata, array('template', (array)$template));
			}
			if($w == 'actions' || $w == 'all') {
				$actions = $this->action->getProzessActions($id);
				if($actions != '' || $actions != null)
					$logdata = array_merge($logdata, $this->_castObjectsToArray($actions, 'action'));
			}
			if($w == 'rulename') {
				$rule = $this->rule->getSelectedRuleForProzess($id, 'CMS');
				$rule_name = '';
				foreach($rule as $r) {
					$rule_name = $r->rr_data_file;
					break;
				}
				$logdata['rule_name'] = $rule_name;
			}
			if($w == 'rule' && $ext_data) {
				$logdata = array_merge($logdata, array('rule' => $ext_data));
			}
			if($w == 'map' || $w == 'all') {
				$map = $this->map->generateProcessMap($id);
				$logdata['map'] = $map;
			}
			if($w == 'other' && $ext_data) {
				$logdata = array_merge($logdata, array('other' => $ext_data));
			}
		}
		#__print($logdata);
		
		#$this->db->debug = 1;
		try {
			$sql = sprintf("INSERT INTO rula2_history 
				(r2h_id, r2h_edit_timestamp, r2h_edit_action, r2h_edit_user, r2h_obj_id, r2h_obj_type, r2h_old_cdata) VALUES 
				('%s', %s, '%s', '%s', '%s', '%s', null)",
				$r2h_id,"TO_DATE('".date('Y-m-d H:i:s')."','YYYY-MM-DD HH24:MI:SS')", $action, $usr, $id, $type
			);

			$stat = $this->db->Execute($sql);
			if(!$stat || $this->db->errorMsg()){
				throw new Exception('Fehler beim logChanges. MSG::'.$this->db->errorMsg());
			}

			$this->db->updateClob('rula2_history', "r2h_old_cdata", base64_encode(serialize($logdata)), "r2h_id = " . $r2h_id);
			
			#__print("controlle:");
			$res = $this->db->getAll('SELECT r2h_old_cdata FROM rula2_history WHERE r2h_id = ' . $r2h_id);
			#__print($res[0]);
			#__print(unserialize(base64_decode($res[0]['R2H_OLD_CDATA'])));
			#exit;
		}
		catch(Exception $e) {
			throw new Exception($e->getMessage());
		}
	}
	
	protected function _castObjectsToArray($objects, $keyname) {
		$result = array();
		
		if(!is_array($objects)) return;
		
		foreach($objects as $key => $val) {
			$result[$keyname.'_'.$key] = (array)$val;
		}
		return $result;
	}
}
