<?php

namespace Vtours\Rula2Engine;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class Prozess extends Rula2Std {

    protected $table;
    protected $pk;
    protected $searchvars = array('pr_name', 'pr_typ');

    public function __construct() {
        $this->table = 'RULA2_PROZESSES';
        $this->pk = 'PR_ID';
        parent::init();
    }

    public function insertProzess($data) {
        try {
            $stat = $this->db->autoexecute($this->table, $data, 'INSERT');

            if ($stat == FALSE || $this->db->errorMsg()) {
                throw new Exception('Fehler im Modul Prozess_Insert. MSG::' . $this->db->errorMsg());
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function updateProzess($data, $id) {
        #__print($data); exit;
        try {
            #$this->db->debug = 1;

            if ($id < 0) {
                throw new Exception('Fehler im Modul Prozess_Update. ID ungültig');
            }

            $saved = $this->getProzessById($id);

            foreach ($data as $key => $value) {
                if ($value != null)
                    $update[$key] = $value;
            }

            if ($data['PR_AKTIV'] == 1) {
                $update['PR_AKTIV'] = 1;
            } else {
                $update['PR_AKTIV'] = 0;
            }
            if ($data['PR_TEST'] == 1) {
                $update['PR_TEST'] = 1;
            } else {
                $update['PR_TEST'] = 0;
            }

            $typ_error = false;
            if($data['PR_TYP'] == 'Subprozess' && $saved['PR_TYP'] == 'Hauptprozess') {
                $scheduler = new Scheduler();
                $s_items = $scheduler->getSchedulerForProcess($id);
                #__print($s_items);

                if(count($s_items) > 0) {
                    $update['PR_TYP'] = 'Hauptprozess';
                    $typ_error = true;
                }
            }

            if (count($update) <= 0 || $update == null || $update == '') {
                throw new Exception('Fehler im Modul Prozess_Update. NO Data to Update');
            }

            $stat = $this->db->autoexecute($this->table, $update, 'UPDATE', "$this->pk = " . $id);

            if ($stat == FALSE || $this->db->errorMsg()) {
                throw new Exception('Fehler im Modul Prozess_Update. MSG::' . $this->db->errorMsg());
            }
            if($typ_error) {
                $msg = 'Fehler im Modul Prozess_Update. MSG:<br />';
                $msg .= 'Der Prozess kann nicht in ein Subprozess umgewandelt werden, da bereits in Verbindung mit folgenden Schedules:<br />';

                foreach($s_items as $item) {
                    $msg .= $item['RSC_NAME']."<br />";
                }
                #__print($msg); exit;
                throw new Exception($msg);
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function getAllProzesses($cms = null, $sort = 0, $id = '') {
        try {
            global $rs;
            //print_r($sort);
            if ($cms == 1) {

                $sql = $this->getWhereForSql($sort);

                $anzPages = $this->countElements($sql);

                if ($sort->actPage == 0 || $sort->actPage == 1 || $sort->actPage == null || $sort == null || $sort == '') {
                    $von = 1;
                    $bis = self::$anzElemente ;

                }else{

                    $bis = ($sort->actPage) * self::$anzElemente;
                    $von = $bis - self::$anzElemente-1;
                }

                $stmt = " select * from ( select $this->table.*,ROW_NUMBER() OVER (ORDER BY UPPER($sort->field) $sort->direction) as element 
						  from $this->table " . $sql . " )
						  where element between $von AND $bis";
                #echo $stmt;
            } else {

                if ($id > 0) {
                    $stmt .= " Select * from $this->table where PR_ID != $id ";
                }else{
                    $stmt = "Select * from $this->table";
                }

            }

            $res = $this->db->getAll($stmt);
            $res['anz'] = $anzPages;

            if ($this->db->errorMsg()) {
                throw new Exception('Fehler im Modul Prozess_GetAll. MSG::' . $this->db->errorMsg());
            }

            return $res;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function getMainProcesses() {
        try {
            $stmt = "Select * from $this->table WHERE PR_TYP = 'Hauptprozess'";
            $res = $this->db->getAll($stmt);
            if ($this->db->errorMsg()) {
                throw new Exception('Fehler im Modul Prozess_getMain. MSG::' . $this->db->errorMsg());
            }
            return $res;
        }
        catch(Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function getSubProcesses($exclude = 0) {
        try {
            $stmt = "Select * from $this->table WHERE PR_TYP = 'Subprozess' AND PR_ID != ".(int)$exclude;
            $res = $this->db->getAll($stmt);
            if ($this->db->errorMsg()) {
                throw new Exception('Fehler im Modul Prozess_getSub. MSG::' . $this->db->errorMsg());
            }
            return $res;
        }
        catch(Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function getProzessById($id) {
        try {
            $stmt = "Select * from $this->table where $this->pk = $id";

            $res = $this->db->GetRow($stmt);

            if ($this->db->errorMsg()) {
                throw new Exception('Fehler beim holen des Datensatzes. MSG::' . $this->db->errorMsg());
            }

            if (!$res) {
                #throw new Exception('ID net vorhanden. ID::' . $id);
                return false;
            } else {
                return $res;
            }

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function deleteProzessById($id) {
        try {
            $stmt = "Delete from $this->table where $this->pk = $id";

            $res = $this->db->Execute($stmt);

            if ($this->db->errorMsg()) {
                throw new Exception('Fehler beim l�schen des Datensatzes. MSG::' . $this->db->errorMsg());
            } else {
                return TRUE;
            }
        } catch (Exception $e) {
            throw Exception($e->getMessage());
        }
    }

    public function removeProcessFromContainer($id, $from) {
        try {
            $this->db->BeginTrans();
            $sql = sprintf("delete from RULAS2_CONTAINER_TO_PROZESS 
				where P_ID = %d AND RC_ID = %d", $id, $from);
            $this->db->Execute($sql);
            if ($this->db->errorMsg()) {
                throw new Exception('Fehler beim entfernen des ProZesses. MSG::' . $this->db->errorMsg());
            }
        }
        catch (Exception $e) {
            $this->db->RollBackTrans();
            throw new Exception($e->getMessage());
        }
        #$this->db->RollBackTrans();
        $this->db->CommitTrans();
    }

    public function getContainersOfProcess($pid) {
        try {
            if($pid < 0 || $pid == null || $pid == ''){
                throw new Exception('Fehler im Prozess (ContainerDaten abholen). Keine Prozessnummer uebergeben.');
            }

            $sql = sprintf('select * from RULA2_PROZESS_TO_CONTAINER WHERE P_ID = %d', $pid);
            $res = $this->db->getAll($sql);

            if($this->db->errorMsg()){
                throw new Exception('Fehler beim holen der Container im Prozess. MSG::'.$this->db->errorMsg());
            };
            return $res;
        }
        catch(Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
}

?>
