<?php

namespace Vtours\Rula2Engine;

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

class Rula2Std
{

    /**
     * @var Zend_Log
     */
    public $log;

    /**
     * @var ADODB_db2
     */
    public $db;

    /**
     * @var Zend_Config_Ini
     */
    public $ini;

    /***
     * @var string
     */
    public $logo;

    /**
     * @var string
     */
    public $client;

    /**
     * @var int
     */
    public static $anzElemente = 20;

    /**
     * @var Rula2Std
     */
    public static $instance = null;

    /**
     * @var int
     */
    public $anzAllElements;

    /**
     * @return Rula2Std|null
     */
    public static function getInstance()
    {
        if (self::$instance == null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function init()
    {

        if (!class_exists('DB', false)) {
            $this->db = Zend_Registry::get('db');
            $this->log = Zend_Registry::get('log');
            if (!Zend_Registry::isRegistered('rulas2')) {
                $this->ini = new Zend_Config_Ini(Zend_Registry::get('config')->configs->rula2);
            } else {
                $this->ini = Zend_Registry::get('rulas2');
            }
            $this->logo = $this->ini->rula2InvoiceLogo;
        } elseif (class_exists('DB', false)) {
            $this->db = \DB::stepIn();
            $this->log = null;
            $this->ini = \Config::stepIn();
            $this->logo = $this->ini->rula2InvoiceLogo;
        }

        if (!class_exists(Config)) {
            $this->client = $this->ini->client;
        } else {
            $this->client = \Config::stepIn()->cfg('PAGE_NAME');
            if ($this->client == 'vtours.de') {
                $this->client = 'vto';
            }
        }
    }

    /**
     * @return string|false
     */
    public function getTableName()
    {
        if (isset($this->table)) {
            return $this->table;
        } else {
            return false;
        }
    }

    /**
     * @param int $sort
     * @return string|void
     */
    protected function getWhereForSql($sort = 0)
    {
        $stmt = null;
        $stat = false;
        if (is_array($_POST['filter'])) {
            $filter = $_POST['filter'];
            foreach ($filter as $key => $value) {
                if ($value != null && $value != '') {
                    if ($key == 0 && !$stat) {
                        $stmt .= "where LOWER(" . $key . ") like '%" . strtolower($value) . "%'";
                        $stat = true;
                    } else {
                        $stmt .= "AND lower (" . $key . ") like '%" . strtolower($value) . "%'";
                    }
                }
            }

            if ((int)$sort == 0) {
                $stmt .= " ORDER BY " . $this->sort[0] . " ASC";
            } else {
                $stmt .= " ORDER BY " . $sort->field . " $sort->direction";
            }

            return $stmt;
        }
    }

    /**
     * @return int
     */
    public function getAllElementsFromSearch()
    {
        return $this->anzAllElements;
    }

    /**
     * @param string $sql
     * @return false|float
     * @throws Exception
     */
    public function countElements($sql)
    {
        try {
            $stmt = "Select count(*) from $this->table " . $sql;

            $res = $this->db->getOne($stmt);

            $this->anzAllElements = $res;

            if ($this->db->errorMsg()) {
                throw new Exception('Fehler beim holen der Anzahl der gesamtseiten');
            }

            return ceil($res / self::$anzElemente);
        } catch (Exception $e) {

            throw new Exception($e->getMessage());
        }
    }

    /**
     * @param bool $typ
     */
    public function setFilterAndPaging($typ = true)
    {
        global $rs;

        if ($typ === 'reset') {
            $data['anz'] = 1;
        } elseif ($typ) {

            $data['anz'] = Context::stepIn()->getVar('anz');
            $data['sort'] = Context::stepIn()->getVar('sort');
            $data['direction'] = Context::stepIn()->getVar('direction');
        }

        $data['filter'] = $_POST['filter'];

        if (is_array($temp = unserialize(
            \tgcSession::StepIn()->getVar('filter_' . $this->table . $rs['usr_name'])))
        ) {
            foreach ($temp as $key => $value) {
                if ($data[$key] == null || $data[$key] == '') {
                    $data[$key] = $value;
                }
            }
        }
        \tgcSession::StepIn()->setVar('filter_' . $this->table . $rs['usr_name'], serialize($data));
    }

    /**
     * @return stdClass
     */
    public function getFilterAndPaging()
    {
        global $rs, $_POST;

        if (is_array($data = unserialize(\tgcSession::StepIn()->getVar('filter_' . $this->table . $rs['usr_name']))) &&
            (is_null(Context::stepIn()->getVar('sort')) || (int)Context::stepIn()->getVar('sort') <= 0 ||
                is_null(Context::stepIn()->getVar('direction')) || is_null(Context::stepIn()->getVar('anz')) ||
                (int)Context::stepIn()->getVar('anz') <= 1)) {


            $sort = new stdClass();

            foreach ($data as $name => $value) {

                if (!(Context::stepIn()->getVar($name))) {

                    if ($name == 'anz') {
                        $sort->actPage = $data[$name];
                    } elseif ($name == 'direction' && $value == 'down') {
                        $sort->direction = 'DESC';
                    } elseif ($name == 'direction' && $value == 'up') {
                        $sort->direction = 'ASC';
                    } elseif ($name == 'sort') {
                        $sort->field = $this->searchvars[$value];
                    } elseif ($name == 'filter' && ($value != null || $value != '') && $sort->field === null) {
                        if (is_array($value)) {
                            foreach ($value as $kTemp => $temp) {
                                if ($temp != '' || $temp != null) {
                                    $sort->field = $kTemp;
                                }
                            }
                        } else {
                            if ($value !== null || $value == '') {
                                $sort->field = $value;
                            }
                        }
                    }
                } else {

                    if ($name == 'anz') {
                        $sort->actPage = Context::stepIn()->getVar($name);
                    }
                    if ($name == 'direction' && Context::stepIn()->getVar($name) == 'down') {
                        $sort->direction = 'DESC';
                    } elseif ($name == 'direction' && Context::stepIn()->getVar($name) == 'up') {
                        $sort->direction = 'ASC';
                    }
                    if ($name == 'sort') {
                        $sort->field = $this->searchvars[Context::stepIn()->getVar($name)];
                    }
                }
            }
        } else {

            $sort = new stdClass();

            if (($stelle = (int)Context::stepIn()->getVar('sort')) >= 0) {
                $sort->field = $this->searchvars[$stelle];
            }
            if (Context::stepIn()->getVar('direction') == 'down' || $data['direction'] == 'down') {
                $sort->direction = "DESC";
            }
            if (Context::stepIn()->getVar('direction') == 'up' || $data['direction'] == 'up') {
                $sort->direction = "ASC";
            }
            if (($anz = (int)Context::stepIn()->getVar('anz')) > 0) {
                $sort->actPage = $anz;
            }
            if ((int)$anz <= 0 && (int)$data['anz'] > 0) {
                $anz = $data['anz'];
            } elseif ($anz <= 0) {
                $anz = 1;
            }
            $sort->actPage = $anz;
        }

        if (!is_array($_POST['filter'])) {
            $_POST['filter'] = $data['filter'];
        }

        return $sort;
    }

    public function deleteFilterAndPaging()
    {
        global $rs;

        \tgcSession::StepIn()->unsetVar('filter_' . $this->table . $rs['usr_name']);
    }
}
