<?php

namespace Vtours\Rula2Engine;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class Options extends Rula2Std {

	protected $table;
	protected $pk;
	protected $pk2;
	protected $mapTable;

	public function __construct() {

		$this->table = 'RULA2_OPTIONS';
		$this->mapTable = 'RULA2_PROZESS_TO_OPTION';
		$this->pk = 'RO_ID';
		$this->pk2 = 'P_ID';
		parent::init();
	}

	public function getAllOptions() {

		try {

			$stmt = "SELECT * from $this->table";

			$res = $this->db->getAll($stmt);

			if ($this->db->errorMsg()) {
				throw new Exception('Fehler beim holen der Options');
			}

			foreach ($res as $key => $value) {

				$item[$key] = new OptionsItem();
				foreach ($value as $attr => $val) {
					$temp = strtolower($attr);
					$item[$key]->$temp = $val;
				}
			}

			return $item;
		} catch (Exception $e) {
			throw new Exception($e->getMessage());
		}
	}

	public function getOptionById($id) {
		
		try{
			$stmt = "Select * from 
				$this->table
				where $this->pk = '" . $id . "'";
			
			$res = $this->db->getAll($stmt);

			if ($this->db->errorMsg())
				throw new Exception('Fehler in der DB  Abfrage um Optionen fuer den Prozess zuholen. MSG:: ' . $this->db->errorMsg());

			$item = new OptionsItem();
			
			if(count($res) > 0){
				foreach ($res[0] as $attr => $val) {
					$temp = strtolower($attr);
					$item->$temp = $val;
					$item->id = $id;
				}
			}
		} catch (Exception $e) {
			throw new Exception($e->getMessage());
		}
		return $item;
	}

	public function getOptionsOfProzess($pid) {

		try {

			$stmt = "Select * from 
					$this->table i,$this->mapTable j
					where j.$this->pk2 = '" . $pid . "'
					and j.$this->pk = i.$this->pk";

			#__print($stmt);
			$res = $this->db->getAll($stmt);

			if ($this->db->errorMsg())
				throw new Exception('Fehler in der DB  Abfrage um Optionen fuer den Prozess zuholen. MSG:: ' . $this->db->errorMsg());

			foreach ($res as $key => $value) {

				$item[$value['RO_ID']] = new OptionsItem();
				foreach ($value as $attr => $val) {
					$temp = strtolower($attr);
					$item[$value['RO_ID']]->$temp = $val;
					$item[$value['RO_ID']]->id = $pid;
				}
			}
		} catch (Exception $e) {

			throw new Exception($e->getMessage());
		}
		//print_r($item);
		return $item;
	}

	public function insertOptionsToProzess($id, $data) {
		try {


			if ($id <= 0 || $id == '' || $id == null || $data == null || $data == '') {
				throw new Exception('Keine Id uebermittelt um Optionen einzufuegen oder zu aktualisieren.');
			}
			$this->db->BeginTrans();

			if (!is_array($data)) {
				$temp['RO_ID'] = $data;
				$temp['P_ID'] = $data;

				$stat = $this->db->autoexecute($this->mapTable, $temp, 'INSERT');

				if (!$stat || $this->db->errorMsg()) {
					$this->db->RollBackTrans();
					throw new Exception('Fehler bei der Uebernahme der Daten in die Option.MSG:: ' . $this->db->errorMsg());
				}
			} else {

				foreach ($data as $value) {
					$temp['RO_ID'] = $value;
					$temp['P_ID'] = $id;

					$stat = $this->db->autoexecute($this->mapTable, $temp, 'INSERT');

					if (!$stat || $this->db->errorMsg()) {
						$this->db->RollBackTrans();
						throw new Exception('Fehler bei der Uebernahme der Daten in die Option.MSG:: ' . $this->db->errorMsg());
					}
				}
			}
			$this->db->CommitTrans(TRUE);
		} catch (Exception $e) {

			$this->db->RollBackTrans();
			throw new Exception($e->getMessage());
		}
	}

	public function deleteOptionsToProzess($id) {
		try {
			#__print("deleteOptionsToProzess($id)");
			if ($id == '' || $id <= 0 || $id == null) {
				$this->db->RollBackTrans();
				throw new Exception('Keine Id geliefert um Option zuloeschen');
			}

			$stmt = "Delete from $this->mapTable where $this->pk2 = $id";

			$this->db->execute($stmt);

			if ($this->db->errorMsg()) {
				$this->db->RollBackTrans();
				throw new Exception('Fehler in der DB Abfrage um Optionen zuloeschen');
			}

			return true;
		} catch (Exception $e) {
			throw new Exception($e->getMessage());
		}
	}

}

?>
