<?php

namespace Vtours\Rula2Engine;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Class File
 */
class File extends Rula2Std
{

    private $root;
    private $bookingDir;
    private $bookingDirProcessed;
    private $processDir;
    private $flugVoucherDir;
    private $flugVoucherDirProcessed;
    private $isFlugFile;
    private $id;
    private $mode;
    private $bookingYear;
    private $bookingMonth;

    /**
     *
     */
    public function init()
    {
        parent::init;
    }

    /**
     * File constructor.
     * @throws Exception
     */
    public function __construct()
    {

        try {
            if (class_exists('DB', false)) {
                $this->root = \Config::stepIn()->cfg('RULA2_ROOT');
            } else {
                $this->root = Zend_Registry::get('rulas2')->root_dir;
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    /**
     * @param $y
     */
    public function setBookingYear($y)
    {
        $this->bookingYear = $y;
    }

    /**
     * @param $m
     */
    public function setBookingMonth($m)
    {
        $this->bookingMonth = $m;
    }

    /**
     * @param $id
     * @return bool
     */
    private function setProcessDir($id)
    {

        if (is_dir($this->root . 'process/' . $id)) {
            $this->processDir = $this->root . 'process/' . $id;
            return true;
        } else {
            if ($this->makeProzessDir($this->root . 'process/' . $id)) {
                $this->processDir = $this->root . 'process/' . $id;
                return true;
            } else
                return false;
        }

    }

    /**
     * @param $id
     * @return bool
     */
    private function setBookingDir($id)
    {

        if (!is_dir($this->root . 'bookings/' . $this->bookingYear . '/' . $this->bookingMonth)) {
            mkdir($this->root . 'bookings/' . $this->bookingYear . '/' . $this->bookingMonth, 0777, true);
            mkdir($this->root . 'bookings/' . $this->bookingYear . '/' . $this->bookingMonth . '/new', 0777, true);
            mkdir($this->root . 'bookings/' . $this->bookingYear . '/' . $this->bookingMonth . '/processed', 0777, true);
        }

        if (is_dir($this->root . 'bookings/' . $this->bookingYear . '/' . $this->bookingMonth . '/new/' . $id)) {
            $this->bookingDir = $this->root . 'bookings/' . $this->bookingYear . '/' . $this->bookingMonth . '/new/' . $id;
            $this->bookingDirProcessed = $this->root . 'bookings/' . $this->bookingYear . '/' . $this->bookingMonth . '/processed/' . $id;
            return true;
        } else {

            if ($this->makeProzessDir($this->root . 'bookings/' . $this->bookingYear . '/' . $this->bookingMonth . '/new/' . $id)) {
                $this->bookingDir = $this->root . 'bookings/' . $this->bookingYear . '/' . $this->bookingMonth . '/new/' . $id;
                $this->bookingDirProcessed = $this->root . 'bookings/' . $this->bookingYear . '/' . $this->bookingMonth . '/processed/' . $id;
                return true;
            } else
                return false;
        }

    }

    /**
     * @param $id
     * @return string
     */
    public function setFlugVoucherDir($id)
    {

        if ($this->setBookingDir($id)) {
            $this->flugVoucherDir = $this->bookingDir . '/flugvoucher';
            $this->flugVoucherDirProcessed = $this->bookingDirProcessed . '/flugvoucher/';
        }

        if (!is_dir($this->flugVoucherDir)) {
            mkdir($this->flugVoucherDir, 0777, true);
        }
        if (!is_dir($this->flugVoucherDirProcessed)) {
            mkdir($this->flugVoucherDirProcessed, 0777, true);
        }

        Zend_Registry::get('log')->info('Flugvoucher Pfad::' . $this->flugVoucherDir);
        Zend_Registry::get('log')->info('Flugvoucher Pfad Processed::' . $this->flugVoucherDirProcessed);

        return $this->flugVoucherDir;
    }

    /**
     * @param $dir
     * @return bool
     */
    private function makeProzessDir($dir)
    {
        if (!is_dir($dir))
            return mkdir($dir, 0777, true);
        else
            $this->log->info('Verzeichniss schon vorhanden');

        return True;

    }

    /**
     * @param $id
     * @param $mode
     * @throws Exception
     */
    public function uploadFiles($id, $mode)
    {

        try {
            //print_r($_FILES);
            if ($_FILES['datei']['tmp_name'] == '' || $_FILES['datei']['tmp_name'] == null) return;

            if ($id == null || $id == '' || $id < 0)
                throw new Exception('Id fuer Upload net uebermittelt');

            if (!is_dir($this->root))
                throw new Exception('Root File nicht vorhanden. Upload wird abgebrochen');
            else {
                switch ($mode) {

                    case 'process':

                        if (!$this->setProcessDir($id))
                            throw new Exception('Kann Prozessordner nicht erstellen');

                        $dir = $this->processDir;

                        break;

                    case 'booking';

                        if (!$this->setBookingDir($id))
                            throw new Exception('Kann Buchungsordner nicht erstellen');

                        $dir = $this->bookingDir;

                        break;

                    case 'flugvoucher':

                        if (!$this->setFlugVoucherDir($id))
                            throw new Exception('Kann Flugordner nicht erstellen');

                        $dir = $this->flugVoucherDir;

                        break;

                    default:
                        throw new Exception('Kein Mode vorhanden');
                        break;

                };


                chmod($dir, 0777);
                chown($dir, 'apache');


                foreach ($_FILES as $data) {
                    if ($data) {
                        if ($data['error'] == 0) {
                            if ($data['size'] > 0) {
                                $stat = move_uploaded_file($data['tmp_name'], $dir . "/" . $data['name']);
                            } else {
                                throw new Exception('Datei scheint leer zusein');
                            }
                        } else {
                            throw new Exception('Beim Upload ist ein Fehler aufgetreten' . $data['error']);
                        }
                    } else {
                        throw new Exception('Keine Datei zum Upload');
                    }
                }
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    /**
     * @param $id
     * @param $mode
     * @return array|bool
     */
    public function getUploadedFiles($id, $mode)
    {
        try {

            if ($id == null || $id == '' || $id <= 0 || $mode == null || $mode == '')
                throw new Exception('Keine Id oder Mode uebermittelt um Files vom Filesystem abzuholen');

            $this->id = $id;
            $this->mode = $mode;

            if (!is_dir($this->root))
                throw new Exception('Hauptverzeichniss nicht erreichbar');

            switch ($mode) {
                case 'process':

                    $this->setProcessDir($id);
                    $dir = $this->processDir;
                    if (!is_dir($dir)) return false;

                    break;

                case 'booking':

                    $this->setBookingDir($id);
                    $dir = $this->bookingDir;
                    if (!is_dir($dir)) return False;

                    break;

                case 'flugvoucher':

                    $this->setFlugVoucherDir($id);
                    $dir = $this->flugVoucherDir;
                    if (!is_dir($dir)) return False;

                    break;

                case 'flugvoucherProcessed':

                    $this->setFlugVoucherDir($id);
                    $dir = $this->flugVoucherDirProcessed;
                    if (!is_dir($dir)) return False;

                    break;

                default:
                    throw new Exception('Kein Mode uebergeben');
            }


            chown($dir, 'apache');
            chmod($dir, 0777);

            if (!($item = $this->getFilesFromDir($id, $dir)))
                return FALSE;

        } catch (Exception $e) {

            //throw new Exception($e->getMessage());

        }

        return $item;

    }

    /**
     * @param $id
     * @param $dir
     * @return array|bool
     * @throws Exception
     */
    private function getFilesFromDir($id, $dir)
    {

        try {
            if (!is_dir($dir)) {
                $this->makeProzessDir($dir);
            }

            if ($dir == null || $dir == '' || !is_dir($dir))
                throw new Exception('Kein Verzeichnis geliefert um Dateien abzuholen');

            if (!$handle = opendir($dir)) {
                throw new Exception('File Pointer kann nicht aufgebauet werden');
            }
            $t = 0;

            $item = array();
            $file = null;
            while (($data = readdir($handle))) {
                try {
                    if ($data !== '.' && $data !== '..' && !stristr('.svn', $data) && !is_dir($dir . '/' . $data)) {
                        $file = new FileItem();
                        $file->dir = $dir;
                        $file->fileName = $data;
                        $file->dirFile = $dir . '/' . $data;
                        $file->id = $this->id;

                        if ($this->mode == 'process')
                            $file->isProcessFile = true;
                        if ($this->mode == 'booking')
                            $file->isBookingFile = true;
                        if ($this->mode == 'flugvoucher')
                            $file->isFlugFile = true;
                        if ($this->mode == 'flugvoucherProcessed')
                            $file->isFlugFile = true;

                        $item[$t] = $file;

                        $t++;
                    }
                } catch (Exception $e) {
                    throw new Exception($e->getMessage());
                }
            }
        } catch (Exception $e) {
            $item = false;
            throw new Exception($e->getMessage());
        }

        if (count($item) <= 0)
            throw new Exception('No Files in Dir::' . $dir);

        return $item;
    }

    /**
     * @param $id
     * @param $fname
     * @param string $mode
     * @return bool
     * @throws Exception
     */
    public function deleteFile($id, $fname, $mode = 'process')
    {

        try {
            if ($id == null || $id == '' || $id <= 0 || $fname == null || $fname == '' || $mode == null || $mode == '')
                throw new Exception('Datei kann nicht gelöscht werden.');

            $this->id = $id;
            $this->mode = $mode;

            if (!is_dir($this->root))
                throw new Exception('Hauptverzeichniss nicht erreichbar');

            switch (trim($mode)) {
                case 'process':
                    $this->setProcessDir($id);
                    $dir = $this->processDir;
                    if (!is_dir($dir)) return false;
                    break;

                case 'flugvoucher':
                    $this->setFlugVoucherDir($id);
                    $dir = $this->flugVoucherDir;
                    if (!is_dir($dir)) return false;
                    break;

                case 'booking':
                    $this->setBookingDir($id);
                    $dir = $this->bookingDir;
                    break;

                default:
                    throw new Exception('Kein Mode uebergeben');
            }
            if (!is_dir($dir))
                throw new Exception('Dateierzeichniss nicht erreichbar');

            $this->_deleteFile($dir, $fname);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    /**
     * @param $dir
     * @param $fname
     */
    private function _deleteFile($dir, $fname)
    {
        #__print($dir."/".$fname);
        unlink($dir . "/" . $fname);
    }
}
