<?php

namespace Vtours\Rula2Engine;

class Scheduler extends Rula2Std
{

    private $day;
    private $time;
    private $pk;
    protected $table;
    private $mapTable;
    private $timeTable;
    protected $searchvars = array('rsc_name');

    public function __construct($day = null, $time = null)
    {

        $this->table = 'RULA2_SCHEDULES';
        $this->mapTable = 'RULA2_PROZESS_TO_SCHEDULE';
        $this->timeTable = 'RULA2_SCHEDULES_ITEM';
        $this->pk = 'RSC_ID';
        $this->pkI = 'RSCI_ID';
        $this->day = $day;

        if ($time != null) {
            $this->time = $time;
            $this->time2 = $this->createTimeInPast();
        }

        parent::init();
    }

    public function getAllSchedulers($cms = 1, $sort = 0)
    {

        try {
            $sql = null;

            if ($cms == 1) {
                $sql .= $this->getWhereForSql($sort);

                $anzPages = $this->countElements($sql);

                if ($sort->actPage == 0 || $sort->actPage == 1 || $sort->actPage == null || $sort == null || $sort == '') {
                    $von = 1;
                    $bis = $von + self::$anzElemente - 1;
                } else {
                    $bis = ($sort->actPage) * self::$anzElemente;
                    $von = $bis - self::$anzElemente + 1;
                }

                $stmt = " select * from 
                            ( 
                             select $this->table.*,
                             (select max(rsci_aktiv) 
                              from $this->timeTable tt where tt.rsc_id = $this->table.$this->pk) as Aktiv,
                              RANK() OVER (ORDER BY $sort->field $sort->direction
			     ) as element 
			  from $this->table " . $sql . " )
			  where element between $von AND $bis";
            } else {
                $stmt = 'Select * from ' . $this->table;
            }

            $res = $this->db->getAll($stmt);

            $res['anz'] = $anzPages;

            if ($this->db->errorMsg()) {
                throw new Exception('Fehler in der DB Abfrage um alle Schedule Tasks abzuholen');
            }
            return $res;
        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    public function getSchedulerInTime()
    {


        try {

            /* $this->time = "00:10";
              $this->time2 = "00:00"; */
            //Hole Scheduler der letzten 10 min bis jetzt

            if (substr($this->time, 0, 5) == "00:00") {
                $this->time = "23:59";
            }
            if (substr($this->time2, 0, 5) == "00:01") {
                $this->time2 = '00:00';
            }

            if ($this->time == null || $this->time2 == null || $this->time == '' || $this->time2 == '') {
                throw new Exception('Keine Zeiten um Scheduler abzurufen');
            }


            $stmt = "select * 
            from $this->table t, $this->timeTable tt , $this->mapTable tm
            where t.$this->pk = tt.$this->pk
            and RSCI_START BETWEEN '$this->time2' AND '$this->time'
            and REGEXP_REPLACE(RSCI_START,'[:.;]','') 
            BETWEEN '" . str_replace(array(':', '.', ';'), '', $this->time2) . "' 
            AND '" . str_replace(array(':', '.', ';'), '', $this->time) . "' 
            and  REGEXP_LIKE(REGEXP_REPLACE(RSCI_START,'[:.]',''), '[0-9]{4}')
            and tm.$this->pk = t.$this->pk
            and (tt.RSCI_DAY = " . date('N') . " OR tt.RSCI_DAY = 8)
            and tt.RSCI_AKTIV = 1
            UNION ALL
            select * from $this->table t, $this->timeTable tt , $this->mapTable tm
            where t.$this->pk = tt.$this->pk
            and tm.$this->pk = t.$this->pk
            and tt.RSCI_DAY in (9,10)
            and tt.RSCI_AKTIV = 1
            and
            (CASE WHEN to_char(SYSTIMESTAMP, 'MI') != '00' THEN 
                (CASE
                    WHEN ((rsci_day = 9 AND rsci_start BETWEEN to_char((SYSTIMESTAMP -interval '9' MINUTE) ,'MI') AND to_char(SYSTIMESTAMP,'MI'))
                        OR ((rsci_day = 10 AND rsci_start BETWEEN to_char((SYSTIMESTAMP -interval '9' MINUTE) ,'MI') AND to_char(SYSTIMESTAMP,'MI'))
                        OR (rsci_day = 10 
                            AND to_char((to_timestamp(rsci_start,'MI')+ interval '30' MINUTE),'MI') BETWEEN to_char((SYSTIMESTAMP -interval '9' MINUTE) ,'MI') 
                            AND to_char(SYSTIMESTAMP,'MI')))) 
                    THEN 1
                    ELSE 0
                END)
            ELSE
                (CASE
                    WHEN ((rsci_day = 9 AND rsci_start >= to_char((SYSTIMESTAMP -interval '9' MINUTE) ,'MI') OR rsci_start = '00')
                        OR ((rsci_day = 10 AND rsci_start >= to_char((SYSTIMESTAMP -interval '9' MINUTE) ,'MI') OR rsci_start = '00')
                            OR (rsci_day = 10 AND to_char((to_timestamp(rsci_start,'MI')+ interval '30' MINUTE),'MI') >= to_char((SYSTIMESTAMP -interval '9' MINUTE) ,'MI')
                            OR rsci_start = '00')))
                    THEN 1
                    ELSE 0
                END)
            END) = 1";

            $res = $this->db->getAll($stmt);
            
            $this->log->info('SQL um Schedulerdaten zuholen '.$stmt);

            if ($this->db->errorMsg()) {
                throw new Exception($this->db->errorMsg());
            }

            foreach ($res as $key => $items) {
                $stat = false;
                $data[$key] = new SchedulerItem();
                foreach ($items as $keyI => $item) {
                    if (!is_int($keyI)) {
                        $data[$key]->$keyI = $item;
                    }
                }

                if (($stat = $data[$key]->checkItem()) != false) {
                    $this->log->err('Fehler bei der Erstellung der Item. Error::' . $stat . 'ID:: ' . $data[$key]->rsc_id);
                    $data[$key]->rpm_error = 1;
                    $data[$key]->rpm_finish = 0;
                    $data[$key]->rpm_active = 0;
                    $data[$key]->rpm_message = $stat;
                }

                $this->log->info('Folgende Scheduler werden geladen. Scheduler Name::' . $data[$key]->rsc_name . "-ID-" . $data[$key]->rsc_id);
            }
        } catch (Exception $e) {
            throw new Exception('Fehler beim holen der Schedulerdaten fuer eine Uhrzeit.MSG::' . $e->getMessage());
        }

        return $data;
    }

    public function insertSchedulerData($data)
    {

        try {
            $stat = $this->db->autoexecute($this->table, $data, 'INSERT');
            if ($stat) {
                $data['id'] = $this->db->getOne("Select MAX(RSC_ID) FROM $this->table");
                $this->deleteInsertSchedulerToProcesses($data);
                \Context::stepIn()->setVar('RSC_ID', $data['id']);
            }
            if ($this->db->errorMsg() || $stat == false) {
                throw new Exception('Fehler im Schedules -- Insert');
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function getSchedulerById($id, $typ = null)
    {

        try {
            $stmt = "Select * 
			from $this->table 
			where RSC_ID = " . (int) $id;

            $res = $this->db->getAll($stmt);

            if ($this->db->errorMsg()) {
                throw new Exception('Fehler im Scheduler um Scheduler Task zuholen');
            }

            $res[0]['prozesse'] = $this->getProcessesForScheduler($id);
            $res[0]['times'] = $this->getTimesForScheduler($id);

            if ($typ == 'obj') {
                $item = new SchedulerItem();
                foreach ($res as $key => $value) {
                    $item->key = $value;
                }
                $item->prozesse = $res[0]['prozesse'];
                $item->times = $res[0]['times'];
                return $item;
            }

            return $res[0];
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function getTimesForScheduler($id)
    {
        try {
            $stmt = sprintf('Select * from %s WHERE RSC_ID = %d', $this->timeTable, $id);

            $res = $this->db->getAll($stmt);
            if ($this->db->errorMsg()) {
                throw new Exception('Fehler in der DB Abfrage um alle Schedule Times abzuholen');
            }

            return $res;
        } catch (Exception $e) {
            throw new Exception($e->getMessage);
        }
    }

    public function getProcessesForScheduler($id)
    {

        try {
            if ($id > 0) {

                $stmt = "Select P_ID from $this->mapTable where RSC_ID = " . $id;

                $res = $this->db->getAll($stmt);

                if ($this->db->errorMsg()) {
                    throw new Exception('Fehler beim holen der Prozesse für den Scheduler. MSG::' . $this->db->errorMsg());
                }
            } else {
                throw new Exception('Fehler beim holen der Prozesse für den Scheduler');
            }

            return($res);
        } catch (Exception $e) {
            throw new Exception($e->getMessage);
        }
    }

    public function getSchedulerForProcess($pid)
    {
        try {
            if ($pid > 0) {

                $stmt = "Select mp.RSC_ID, s.RSC_NAME 
                            from $this->mapTable mp 
                            left join $this->table s ON s.RSC_ID = mp.RSC_ID
                            where mp.P_ID = " . $pid;
                #__print($stmt);
                $res = $this->db->getAll($stmt);
                if ($this->db->errorMsg()) {
                    throw new Exception('Fehler beim holen der Prozesse für den Scheduler. MSG::' . $this->db->errorMsg());
                }

                return($res);
            } else {
                throw new Exception('Fehler beim holen der Scheduler für den Prozess');
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage);
        }
    }

    public function updateSchedulerData($data)
    {
        try {

            $data['RSC_ID'] = $data['id'];
            //$this->db->debug = 1;
            #__print($data);

            $this->deleteInsertSchedulerToProcesses($data);

            if ($data['RSC_ID'] > 0) {
                $stat = $this->db->AutoExecute($this->table, $data, 'UPDATE', "RSC_ID = " . $data['RSC_ID']);
            } else {
                throw new Exception('UPDATE der Daten im Scheduler fehlgeschlagen');
            }
            if ($this->db->errorMsg() || $stat == false) {
                throw new Exception('UPDATE der Daten im Scheduler. DB Update Fehler. MSG::' . $this->db->errorMsg(), FALSE);
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function deleteSchedulerData($data)
    {
        $this->db->BeginTrans();

        try {

            $this->_deleteMap((int) $data['RSC_ID']);
            if ($this->db->errorMsg()) {
                $this->db->RollBackTrans();
                throw new Exception('Fehler beim löschen: Mapping im Scheduler');
            }

            $this->_deleteTimes((int) $data['RSC_ID']);
            if ($this->db->errorMsg()) {
                $this->db->RollBackTrans();
                throw new Exception('Fehler beim löschen: Times im Scheduler');
            }

            $this->db->Execute(sprintf("delete from %s WHERE RSC_ID = %d", $this->table, $data['RSC_ID']));
            if ($this->db->errorMsg()) {
                $this->db->RollBackTrans();
                throw new Exception('Fehler beim löschen: Times im Scheduler');
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

        $this->db->CommitTrans(true);
    }

    public function deleteInsertSchedulerToProcesses($data)
    {

        #$this->db->debug = 1;
        $this->db->BeginTrans();

        try {
            $this->_deleteMap((int) $data['id']);
            if ($this->db->errorMsg()) {
                $this->db->RollBackTrans();
                throw new Exception('Fehler beim löschen: Mapping im Scheduler');
            }

            $this->_deleteTimes((int) $data['id']);
            if ($this->db->errorMsg()) {
                $this->db->RollBackTrans();
                throw new Exception('Fehler beim löschen: Times im Scheduler');
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

        // Mapping füllen
        if(!is_array($data['prozesse']) || count($data['prozesse']) <= 0) {
            return;
        }

        foreach ($data['prozesse'] as $key => $value) {
            try {
                if ($value > 0) {

                    $map['RSC_ID'] = $data['id'];
                    $map['P_ID'] = $value;

                    $stat = $this->db->AutoExecute($this->mapTable, $map, 'INSERT');

                    if ($this->db->errorMsg() || $stat == false) {
                        $this->db->RollBackTrans();
                        throw new Exception('Fehler beim erstellen der ProzessSchedulerMap Tabelle MSG::' . $this->db->errorMsg());
                    }
                }
            } catch (Exception $e) {
                throw new Exception($e->getMessage());
            }
        }

        // Times füllen

        foreach ($data['day'] as $k => $v) {
            if ($v <= 0 || $v > 11) {
                throw new Exception('Day is wrong');
            }
            $data['startTime'][$k] = str_replace(array(',', '.', ';'), ':', $data['startTime'][$k]);


            if($v == 9 || $v == 10) {
                if($data['startTime'][$k] < 0 || $data['startTime'][$k] > 59 || !preg_match("/^[0-9]{2}$/",$data['startTime'][$k])) {
                    throw new Exception('Startparameter is wrong');
                }
            }elseif (!$this->timeCheck($data['startTime'][$k])) {
                throw new Exception('Time is wrong');
            }
            #$this->db->debug = true;
            try {
                if ($v > 0) {
                    $map = array(
                        'RSC_ID' => $data['id'],
                        'RSCI_DAY' => $data['day'][$k],
                        'RSCI_START' => $data['startTime'][$k],
                        'RSCI_AKTIV' => (int) $data['dayActive'][$k] == 1 ? '1' : '0',
                    );

                    $stat = $this->db->AutoExecute($this->timeTable, $map, 'INSERT');
                    #__print($this->db->);
                    if ($this->db->errorMsg() || $stat == false) {
                        $this->db->RollBackTrans();
                        throw new Exception('Fehler beim erstellen der ProzessScheduler Timetable MSG::' . $this->db->errorMsg());
                    }
                }
            } catch (Exception $e) {
                throw new Exception($e->getMessage());
            }
        }

        $this->db->CommitTrans(true);
    }

    public function deleteProcessFromScheduler($pid, $rscid = 0)
    {
        try {
            $whereand = $rscid ? sprintf(' AND RSC_ID = %d', $rscid) : '';
            $sql = sprintf('DELETE FROM %s WHERE P_ID = %d %s', $this->mapTable, $pid, $whereand);
            $stat = $this->db->Execute($sql);

            if ($this->db->errorMsg() || $stat == false) {
                $this->db->RollBackTrans();
                throw new Exception('Fehler beim Loeschen des Prozesses aus dem Scheduler MSG::' . $this->db->errorMsg());
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    //Mapping Tabelle aufrauemen
    protected function _deleteMap($id)
    {

        $this->db->execute('Delete from ' . $this->mapTable . ' where RSC_ID = ' . $id);
    }

    // Schedule times aufräumen
    protected function _deleteTimes($id)
    {
        $this->db->execute('Delete from ' . $this->timeTable . ' where RSC_ID = ' . $id);
    }

    protected function createTimeInPast()
    {

        $temp = explode(':', $this->time);
        return date('H:i', mktime($temp[0], $temp[1] - 9, 0, 0, 0, 0));
    }

    protected function checkTime()
    {

        $temp = explode(':', $this->time);

        return date('H:i', mktime($temp[0], $temp[1] - 10, 0, 0, 0, 0));
    }

    private function timeCheck($time)
    {

        $item = new SchedulerItem();
        $stat = $item->timeCheck($time);

        return $stat;
    }

    public function deleteSchedulerItem($obj)
    {
        try {


            $stmt = "delete from $this->timeTable 
					 where $this->pk = " . $obj->id;
            if ($obj->day != '' && $obj->day != null) {
                $stmt .= "and RSCI_DAY = '$obj->day'";
            }
            if ($obj->time != '' && $obj->time != null) {
                $stmt .= "and RSCI_START = '$obj->time'";
            }

            $this->db->execute($stmt);

            if ($this->db->errorMsg()) {
                throw new Exception($this->db->errorMsg());
            }

            return true;
        } catch (Exception $e) {

            throw new Exception("Fehler beim löschen der Datensaetze. MSG::" . $e->getMessage() . " obj:: " . print_r($obj, true));
        }
        #echo $stmt;
    }
}
