<?php

namespace Vtours\Rula2Engine\Booking;

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

use Vtours\Rula2Engine\Extendablemagic;


/**
 * Class Pricecorrections
 */
class Pricecorrections extends Extendablemagic
{
    public function initValues()
    {
        if ($this->vt_price_correctiontype == 'NCH'
            && !$this->vt_price_name
        ) {
            $this->displaySeparatelyPrice = true;
        } else {
            $this->displaySeparatelyPrice = false;
        }
    }

    /**
     * @return string
     */
    public function getVtPriceCorrectionType()
    {
        return $this->_Datastore['vt_price_correctiontype'];
    }

    /**
     * @return string
     */
    public function getVtPriceDescription()
    {
        return $this->_Datastore['vt_price_description'];
    }

    /**
     * @return string
     */
    public function getVtPricePrice()
    {
        return $this->_Datastore['vt_price_price'];
    }
}
