<?php

namespace Vtours\Rula2Engine\Booking;

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */
use Vtours\Rula2Engine\Rula2Std;
use Exception;

class Transferinfo extends Rula2Std{
	
	public $rti_zielgebiet;
	public $rti_transfercode;
	public $rti_added;
	public $rti_updated;
	public $rti_transferinfo;
	
	public function __construct(){
		
		$this->table = 'Rula_Transfer_Information';
		parent::init();
	}
	
	public function __get($name){
		if(isset($name))
			return $this->$name;
		else
			return null;
	}
	
	public function __set($name,$value){
		
		if(!is_numeric($name)){
			$temp = strtolower ($name);
			$this->$temp = $value;
		}
			
	}
	
	public function getTransferInfos($zielgebiet,$transfercode){
		
		if($zielgebiet == null && $transfercode == null)
			return;
		
		if(strtolower($transfercode) == 'novuma'){
			$transfercode = 'novumayt';
		}
		
		$stmt = "SELECT * 
				 FROM $this->table 
				 WHERE lower(RTI_ZIELGEBIET) = '".strtolower($zielgebiet)."'
				 AND lower(RTI_TRANSFERCODE) = '".strtolower($transfercode)."'";
		
		
		$res = $this->db->getAll($stmt);
		
		if($this->db->errorMsg()){
			throw new Exception('Fehler in der DB Abfarge um Daten zuholen');
		}
		
		if(count($res) <= 0 || $res == null  || $res == '')
			return '';
		
		foreach($res[0] as $key => $value){
			
			if(!is_numeric($key)){
				$temp = strtolower($key);
				$this->$temp = $value;
			}
		}
	}
	
	public function getHtml(){
		return str_replace('\r\n', '<br />', $this->rti_transferinfo);
	}
	
	public function getText(){
		return str_replace('<br />', '\r\n', $this->rti_transferinfo);
	}
}

