<?php

namespace Vtours\Rula2Engine;

/**
 * *
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 *
 */

use Exception;

class Container extends Rula2Std {

	private $table;
	private $pTable;
	private $pk;
	private $pk1;
	private $tableProcessContainerItem;
	private $tableContainerProcessItem;

	public function __construct() {

		$this->table = 'RULA2_CONTAINER';
		$this->tableProcessContainerItem = 'RULA2_PROZESS_TO_CONTAINER';
		$this->tableContainerProcessItem = 'RULAS2_CONTAINER_TO_PROZESS';
		$this->pTable = 'RULA2_PROZESSES';
		$this->pk = 'RC_ID';
		$this->pk1 = 'P_ID';
		$this->pk2 = 'PR_ID';
		parent::init();
		
	}

	public function getAllContainer() {
		try {
			$stmt = "select * from $this->table";

			$res = $this->db->getAll($stmt);

			if ($this->db->errorMsg()) {
				throw new Exception('Fehler beim holen der Container');
			}

			return $res;
		} catch (Exception $e) {
			throw new Exception($e->getMessage());
		}
	}

	public function getContainerForProzessId($pid) {
		try {
			
			if ($pid < 0 || $pid == null ||  $pid == ''){
				throw new Exception('Fehler im Container(ContainerDaten abholen).Keine Prozessnummer uebergeben.');
			}
			
			$stmt = "select * from 
					 $this->tableProcessContainerItem i ,$this->table j 
					 where i.$this->pk1 = $pid
					 and i.$this->pk = j.RC_ID
					 order by prio asc";
			
			$res = $this->db->getAll($stmt);

			if ($this->db->errorMsg()) {
				throw new Exception('Fehler im Container(Prozessdaten abholen).MSG:: ' .$stmt.' '. $this->db->errorMsg());
			}

			return $res;
			
		} catch (Exception $e) {
			throw new Exception($e->getMessage());
		}
	}
	
	public function getProzessesOfContainer($cid){
		try{
			
			
			if($cid < 0 || $cid == null || $cid == ''){
				throw new Exception('Fehler im Container(ContainerDaten abholen).Keine Prozessnummer uebergeben.');
			}
			
			$stmt = "select * from 
					 $this->tableContainerProcessItem i,$this->pTable j
					 where i.$this->pk = $cid
					 and i.$this->pk1 = j.$this->pk2
					 order by prio asc";
			
			$res = $this->db->getAll($stmt);
			
			if($this->db->errorMsg()){
				
				throw new Exception('Fehler beim holen der Prozesse im Container. MSG::'.$this->db->errorMsg());
				
			}
			
			return $res;
			
		}catch(Exception $e){
			throw new Exception($e->getMessage());
		}	
	}

	public function insertContainerData($data) {
		try {
			if ($data['id'] < 0) {
				throw new Exception('Fehler im InsertData. Keine Prozess Id uebermittelt');
			}

			$stat = $this->db->autoExecute($this->table, $data, 'INSERT');

			if ($stat == FALSE || $this->db->errorMsg()) {
				throw new Exception('Fehler im InsertContainer.MSG::' . $this->db->errorMsg());
			}
		} catch (Exception $e) {
			throw new Exception($e->getMessage());
		}
		return True;
	}

	public function getLastContainerId() {
		try {
			$stmt = "select max(RC_ID) from $this->table";

			$id = $this->db->getOne($stmt);

			if ($this->db->errorMsg()) {
				throw new Exception('Fehler beim holen der letzten ID. MSG::' . $this->db->errorMsg());
			}
		} catch (Exception $e) {
			throw new Exception('Fehler beim holen der letzten ID. MSG::' . $this->db->errorMsg());
		}
		return $id;
	}
	
	public function setPrioProzessToContainer($data,$cid){
		
		try{
			
			if(!is_array($data) || count($data) <= 0) return;
			
			if(!preg_match('/^[0-9]+$/', $cid)){
				throw new Exception('Keine ContainerId erhalten im '.__METHOD__);
			}
			
			#$handle = fopen('C:/Temp/rulas2.txt','a+');
			#fwrite($handle,"#################################################################\r\n");
			foreach($data as $key => $value){
				try{
					if((int)$value >= 0){
						$stmt = "update $this->tableContainerProcessItem 
								 set PRIO = $value 
								 where rc_id = $cid and p_id = $key";
						
						#fwrite($handle,$stmt."\r\n");
						$stat = $this->db->execute($stmt);
						if(!$stat || $this->db->errorMsg()){
							throw new Exception('Fehler bei der Priovergabe im '.__METHOD__.' MSG::'.$this->db->errorMsg());
						}
					}
				}catch(Exception $e){
					throw new Exception($e->getMessage());
				}
			}
			
		}catch(Exception $e){
			
			throw new Exception($e->getMessage());
		}
		
	}
	
	public function setPrioContainerToProzess($data,$pid){
		
		try{
			if(!is_array($data) || count($data) <= 0) return;
			
			if(!preg_match('/^[0-9]+$/', $pid)){
				throw new Exception('Keine ProzessId erhalten im '.__METHOD__);
			}
			
			#$handle = fopen('C:/Temp/rulas2.txt','a+');
			#fwrite($handle,"#################################################################\r\n");
			#fwrite($handle,print_r($data,1));
			
			foreach($data as $key => $value){
				try{
					if((int)$value >= 0){
						$stmt = "update $this->tableProcessContainerItem 
								 set PRIO = $value 
								 where p_id = $pid and rc_id = $key";
						#fwrite($handle,$stmt."\r\n");
						$stat = $this->db->execute($stmt);
						
						if(!$stat || $this->db->errorMsg()){
							throw new Exception('Fehler bei der Priovergabe im '.__METHOD__.' MSG::'.$this->db->errorMsg());
						}
					}
				}catch(Exception $e){
					throw new Exception($e->getMessage());
				}
			}
			
		}catch(Exception $e){
			throw new Exception($e->getMessage());
		}
		
	}
	
	public function addContainerToProzess($data, $cid) {
		try {
			
			$this->db->BeginTrans();
			
			if ($this->deleteContainerFromProzess($cid)) {

				$stat = $this->db->autoExecute($this->tableProcessContainerItem, $data, 'INSERT');

				if ($this->db->errorMsg() || $stat == FALSE) {
					$this->db->RollBackTrans();
					throw new Exception('Fehler beim ablegen in die ContainerToProzess. MSG::' . $this->db->errorMsg());
				}
			} else {
				
				$this->db->RollBackTrans();
				
			}
			
			$this->db->CommitTrans();
			
			return True;
		} catch (Exception $e) {
			$this->db->RollBackTrans();
			throw new Exception($e->getMessage());
		}
	}
	
	public function addProzessToContainer($data,$cid){
		#__print(__METHOD__);
		try{
			#$this->db->debug = 1;
			//__print($data);
			
			//print_r($data);
			
			$this->db->BeginTrans();
			
			if($cid < 0 || $cid == '' || $cid == null){
				throw new Exception('Fehler im addProcessToContainer. Keine Containernummer vorhanden.');
			}
			
			if($this->deleteProzessesFromContainer($cid)){
				
				foreach($data as $value){
					
					$this->db->autoExecute($this->tableContainerProcessItem,$value,'INSERT');
					
					if($this->db->errorMsg()){
						#$this->db->RollBackTrans();
						#echo $this->db->errorMsg();
						throw new Exception('Fehler beim Insert im addProcessToContainer. MSG:: '.$this->db->errorMsg());
					}
				}
			}
		}
		catch(Exception $e){
			$this->db->RollBackTrans();
			throw new Exception($e->getMessage());
		}
		
		$this->db->CommitTrans();
		
		return TRUE;
	}
	
	public function isInsertProcessPossible($hpr_id, $rc_id, $ids, $new_processes) {
		$map = new Map();
		$ids = $map->getProzessStoreInformationForFirstContainer($hpr_id);
		
		$nav = $map->getContainerObject($rc_id);

		if(is_array($nav->navElements))
			$navKey = $nav->navElements[0];
		else
			$navKey = $nav->navElements;
		
		foreach($new_processes as $new_item) {
			foreach($ids as $prozess) {
				foreach($prozess as $pos => $current_prozess) {
					#if($current_prozess == $new_item['P_ID'])
					
					if($current_prozess == $new_item['P_ID'] && $pos != $navKey && $pos == substr($navKey, 0, $length)){	
						return false;
					}
				}
			}
			$map = new Map();
			$ids2 = $map->getProzessStoreInformationForFirstContainer($new_item['P_ID']);
		}
		
	}
	
	// Remove ALL processe from given container
	public function deleteProzessesFromContainer($cid) {
		try {
			if ($cid < 0 || $cid == null || $cid == '') {
				throw new Exception('Keine ContainerId uebermittelt um Prozess zu entfernen.');
			}
			$stmt = "Delete from $this->tableContainerProcessItem where RC_ID = $cid";
			#__print($stmt);
			$this->db->execute($stmt);

			if ($this->db->errorMsg()) {
				throw new Exception('Fehler beim loeschen der Daten aus der Container Prozess.MSG::' . $this->db->errorMsg());
			}
		}
		catch (Exception $e) {
			throw new Exception($e->getMessage());
		}
		return true;
	}

	public function deleteContainerFromProzess($cid, $trans = false) {
		try {
			if($trans) $this->db->BeginTrans();
			
			if ($cid < 0 || $cid == null || $cid == '') {
				throw new Exception('Keine ContainerId uebermittelt um Container zu entfernen.');
			}

			// Remove all direct children
			$this->deleteProzessesFromContainer($cid);
			
			// Remove container from relationship table
			$stmt = "Delete from $this->tableProcessContainerItem where RC_ID = $cid";
			#__print($stmt);
			$this->db->execute($stmt);
			
			// Container has no more relations - delete it premanently
			$stmt = sprintf('delete from %s where RC_ID = %d', $this->table, $cid);
			$this->db->execute($stmt);

			if ($this->db->errorMsg()) {
				throw new Exception('Fehler beim loeschen der Daten aus der Container Prozess.MSG::' . $this->db->errorMsg());
			}
			
		}
		catch (Exception $e) {
			if($trans) $this->db->RollBackTrans();
			throw new Exception($e->getMessage());
		}
		//echo "ende";
		#$this->db->RollBackTrans();
		if($trans) $this->db->CommitTrans();
		return true;
	}
	
	public function updateContainerData($arr){
		
		try{
			
			if($arr['cid'] >= 0){
				
				$id = $arr['cid'];
				unset($arr['cid']);
				
				$stat = $this->db->autoexecute($this->table,$arr,'UPDATE',"$this->pk = '$id'");
				
				if(!$stat ||$this->db->errorMsg()){
					
					throw new Exception('Fehler beim Updaten der Daten. MSG::'.$e->getMessage());
					
				}
			}else{
				throw new Exception('Keine Id um Container upzudaten');
			}
			
			return TRUE;
			
		}catch(Exception $e){
			throw new Exception($e->getMessage());
		}
		
	}
}

?>
