<?php

namespace Vtours\Rula2Engine\Booking;

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

use Vtours\Rula2Engine\Extendablemagic;
use Vtours\Rula2Engine\Booking;
use Exception;


class FullBooking extends Extendablemagic
{

    private $adults = 0;
    private $childs = 0;
    private $infants = 0;
    private $hotelArray = null;

    /**
     * @var Booking\BookingCore
     */
    public $coreData;

    public function __construct()
    {
        $this->_Datastore = array(
            'vt_bo_id' => 0,
            'coreData' => null,
            'customerData' => null,
            'hotelData' => null,
            'participants' => array(),
            'savedFlight' => array(),
            'flighttimes' => array(),
            'airportInfo' => array(),
            'transferInfo' => array(),
            'attachFiles' => array(),
            'countRooms' => 0,
            'transferAg' => array(),
            'hotelInc' => array(),
            'priceCorrection' => array(),
            'hotelDataForVoucher' => array(),
            'xlowContactFlight' => array(),
            'zgInc' => array(),
            'hotelDataForInvoice' => array()
        );
    }

    public function fetchAllData($book_id = null, $core = null, $configData = null)
    {
        try {
            $this->priceCorrection = array();
            $sql = new Booking\BookingSql();

            $sql->init();

            if ($core == null) {
                $core = $sql->getCoreData($book_id);
                $configData = $core['config'];
            } else {
                $this->coreData = $core;
            }

            $this->coreData = new Booking\BookingCore($core);
            $this->coreData->logopool_logo = $sql->getLogopoolImage($this->coreData->vt_bo_agencyno);
            $this->vt_bo_id = $this->coreData->vt_bo_id;
            $hotel = $sql->getHotelData($this->coreData);

            $this->hotelArray = $hotel;
            $this->hotelData = new Booking\BookingHotel($hotel[0]);

            foreach ($hotel as $keyh => $hotelItem) {
                $this->_Datastore['hotelDataForVoucher'][$keyh] = new Booking\BookingHotel($hotelItem);
            }

            if (strtolower($this->coreData->vt_bo_paymethod) == 'l') {
                try {

                    $bankDataObj = $sql->getBankData($this->coreData->vt_bo_id);
                    $this->coreData->iban = $bankDataObj->iban;
                    $this->coreData->bic = $bankDataObj->bic;
                } catch (Exception $e) {
                    if (!class_exists('DB', false)) {
                        \Zend_Registry::get('log')->err($e->getMessage());
                    } else {
                        echo $e->getMessage();
                    }
                }
            }

            $master = $sql->getBookingMasterData($this->coreData);
            foreach ($master as $k => $v) {
                $key = strtolower($k);
                $this->coreData->$key = $v;
            }

            $participants = $sql->getParticipantsData($this->coreData);

            foreach ($participants as $item) {
                $p = new Booking\BookingPassenger($item);
                $this->addPassenger($p);
            }

            $this->setCustomerData();
            $savedFlights = $sql->getSavedFlights($this->coreData);

            foreach ($savedFlights as $number => $item) {
                if ($number == 0 && $configData->tables['VT_FLIGHT_SAVED'] == 1) {
                    foreach ($item as $key => $value) {
                        $temp = strtolower($key);
                        $this->coreData->$temp = $value;
                    }
                }
                $p = new Booking\BookingSavedFlight($item);
                $this->addFlight($p);
            }

            $flighttimes = $sql->getFlighttimes($this->coreData);
            foreach ($flighttimes as $item) {
                foreach ($item as $key => $value) {
                    if (strtoupper($key) == 'FLI_FLIGHTDEPARTURE' || strtoupper($key) == 'FLI_FLIGHTDESTINATION'
                        || strtoupper($key) == 'FLI_DEP_EXT' || strtoupper($key) == 'FLI_DEST_EXT'
                        || strtoupper($key) == 'FLI_DEP_EXT_I' || strtoupper($key) == 'FLI_DEST_EXT_I'
                    ) {
                        if (preg_match('/[öäü]+/', $value)) {
                            $item[$key] = str_replace(array('ü', 'ä', 'ö'), array('Ü', 'Ä', 'Ö'), $value);
                        }
                    }
                }
                $p = new Booking\BookingFlightSegment($item);
                $this->addFlightsegment($p);
            }

            $flighttimesHistory = $sql->getFlighttimesFromHistory($this->coreData);
            foreach ($flighttimesHistory as $item) {
                foreach ($item as $key => $value) {
                    if (strtoupper($key) == 'FLI_FLIGHTDEPARTURE' || strtoupper($key) == 'FLI_FLIGHTDESTINATION'
                        || strtoupper($key) == 'FLI_DEP_EXT' || strtoupper($key) == 'FLI_DEST_EXT'
                    ) {
                        if (preg_match('/[öäü]+/', $value)) {
                            $item[$key] = str_replace(array('ü', 'ä', 'ö'), array('Ü', 'Ä', 'Ö'), $value);
                        }
                    }
                }
                $p = new Booking\BookingFlightSegment($item);
                $this->addFlightsegmentFromHistory($p);
            }

            $this->priceCorrection = $sql->getPriceCorrections($this->coreData->vt_bo_id);

            $this->countRooms = $sql->getCountRoom($this->coreData->vt_bo_id);

            $temp = $sql->getHotelIncomingAgencies($this->coreData);

            $this->_Datastore['hotelInc'] = $temp[0];

            $this->_Datastore['zgInc'] = $sql->getIncomingAgenciesForZG($this->coreData);

            if ($configData->tables['VT_HISTORY'] == 1) {
                $sql->getHistoryData($this->coreData);
            }
            if ($configData->tables['VT_RECLAMATION'] == 1) {
                $sql->getReclamationData($this->coreData);
            }
            if ($configData->tables['VT_RECLAMATION_COUPON'] == 1) {
                $sql->getReclamationCouponData($this->coreData);
            }
            if ($configData->tables['VT_RECLAMATION_REFUND'] == 1) {
                $sql->getReclamationRefundData($this->coreData);
            }
            if ($configData->tables['VT_BOOKINGS_PARAMETER'] == 1) {
                $data = $sql->getBookingParameter($this->coreData);
            }
            if ($configData->tables['VT_EFT_INVALID'] == 1) {
                $sql->vftInvalidData($this->coreData);
            }
            if ($configData->tables['VT_CC_GUWID'] == 1) {
                $sql->vtcGuWidData($this->coreData);
            }
            if ($configData->tables['VT_FLIGHTS'] == 1) {
                //Erstmal fuer die RulesEngine wird der erste Flug geholt zum ueberpruefen
                $sql->vtFirstFlightsData($this->coreData);
            }
            if ($configData->tables['VT_DUNNINGS'] == 1) {
                //Erstmal fuer die RulesEngine wird der erste Flug geholt zum ueberpruefen
                $sql->vtDunnings($this->coreData);
            }
            if ($configData->tables['VT_BONITATSPRUEFUNG'] == 1) {
                //Erstmal fuer die RulesEngine wird der erste Flug geholt zum ueberpruefen
                $sql->getBoenitaetsData($this->coreData);
            }
            if ($configData->tables['ZAHLUNGSIMPORT_ITEM'] == 1) {
                //Erstmal fuer die RulesEngine wird der erste Flug geholt zum ueberpruefen
                $sql->getZahlungsImportData($this->coreData);
            }


            $this->coreData->payCodeLinks = $sql->getPayCodeLinks($this->coreData->vt_bo_id);

            $this->coreData->ryanair_email = $this->getEmailAdressForRyanair($sql);

            if (strtolower($this->coreData->vt_bo_client) == 'ultra') {
                $this->_Datastore['ultraTransfers'] = $sql->getUltraTransferData($this->coreData);
            }

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function setCustomerData()
    {
        $customer = new Booking\BookingCustomer();
        foreach ($this->participants as $part) {

            if ($part->booker) {
                $customer->vt_customer_name = $part->pa_name;
                $customer->vt_customer_firstname = $part->pa_firstname;
                $customer->vt_customer_salutation = $part->pa_address;
                #$this->coreData->vt_bo_customer_salutation = $part->pa_address;
                //$customer->vt_customer_salutation = $part->pa_address;
            }
            if (strtoupper($part->pa_address) == 'CHD') {
                $this->childs++;
            } elseif (strtoupper($part->pa_address) == 'BABY') {
                $this->infants++;
            } else {
                $this->adults++;
            }
        }

        if (!$customer->vt_customer_salutation) {
            $customer->vt_customer_salutation = "Frau / Herr";
        }

        if (!$customer->vt_customer_name) {
            $customer->vt_customer_name = $this->coreData->vt_bo_customer_name;
        }

        if (!$customer->vt_customer_firstname) {
            $customer->vt_customer_firstname = $this->coreData->vt_customer_firstname;
        }

        $customer->vt_customer_street = $this->coreData->vt_bo_customer_street;
        $customer->vt_customer_zipcode = $this->coreData->vt_bo_customer_zipcode;
        $customer->vt_customer_city = $this->coreData->vt_bo_customer_city;
        $customer->vt_customer_country = $this->coreData->vt_bo_customer_country;

        $this->customerData = $customer;
    }

    public function getTicketArt()
    {
        $flights = $this->savedFlight;

        $ticketart = array();
        foreach ($this->savedFlight as $fl) {
            if (!in_array($fl->vt_fli_sv_tickettype, $ticketart)) {
                $ticketart[] = $fl->vt_fli_sv_tickettype;
            }
        }
        return $ticketart;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->coreData->vt_bo_internaltreatmentconditi;
    }

    /**
     * @return int
     */
    public function getAdultsOfBookings()
    {
        return $this->adults;
    }

    /**
     * @return int
     */
    public function getChildsOfBookings()
    {
        return $this->childs;
    }

    /**
     * @return int
     */
    public function getInfantsOfBookings()
    {
        return $this->infants;
    }

    /**
     * @param int $key
     * @return string
     */
    public function getSchalterInfo($key = 0)
    {
        return nl2br($this->savedFlight[$key]->vt_fli_sv_sachlterinfo);
    }

    /**
     * @return int
     */
    public function getAnzParticipants()
    {
        return count($this->participants);
    }

    /**
     * @return int
     */
    public function getAnzFlightData()
    {
        return count($this->savedFlight);
    }

    /**
     * @param int $key
     * @return string
     */
    public function getAirlineCodeAndName($key = 0)
    {
        return $this->savedFlight[$key]->airlinecodeandname;
    }

    /**
     * @param int $key
     * @return string
     */
    public function getAirline($key = 0)
    {
        return $this->savedFlight[$key]->airline;
    }

    /**
     * @return bool|string
     */
    public function calculateParticipantsData()
    {
        $temp = null;
        foreach ($this->participants as $value) {
            if (strtoupper($value->pa_address) == 'K' || strtoupper($value->pa_address) == 'B') {
                //@TODO Irgendwie gibt es das Kinderalter nicht...
                $this->kinderAlterArr[$value->pa_participant_no] = $value->pa_age;
                $temp .= $value->pa_age . ";";
                $this->anzKinder++;
            }
            if (strtoupper($value->pa_address) == 'FRAU' || strtoupper($value->pa_address) == 'HERR') {
                $this->anzErwachsene++;
            }
        }
        return substr($temp, 0, -1);
    }

    /**
     * @param array $passenger
     */
    public function addPassenger($passenger)
    {
        $this->_Datastore['participants'][] = $passenger;
    }

    /**
     * @param array $flight
     */
    public function addFlight($flight)
    {
        $this->_Datastore['savedFlight'][] = $flight;
    }

    /**
     * @param array $flightsegment
     */
    public function addFlightsegment($flightsegment)
    {
        $this->_Datastore['flighttimes'][] = $flightsegment;
    }

    /**
     * @param array $flightsegment
     */
    public function addFlightsegmentFromHistory($flightsegment)
    {
        $this->_Datastore['flighttimesHistory'][] = $flightsegment;
    }

    /**
     * @param string $ai
     */
    public function addAirportInfo($ai)
    {
        $this->_Datastore['airportInfo'][] = $ai;
    }

    /**
     * @param string $key
     * @param string $val
     */
    public function __set($key, $val)
    {
        if (!array_key_exists($key, $this->_Datastore)) {
            return;
        }
        $this->_Datastore[$key] = $val;
    }

    /**
     * @return mixed|null|string|string[]
     */
    public function getBookerData()
    {
        return $this->customerData;
    }

    /**
     * @return string
     */
    public function getTransferAgencyData()
    {
        return $this->_Datastore['transferAg'];
    }

    /**
     * @return string
     */
    public function getHotelIncomingData()
    {
        return $this->_Datastore['hotelInc'];
    }

    /**
     * @return string
     */
    public function getXlowContactDataForTemplate()
    {
        return $this->_Datastore['xlowContactFlight'];
    }

    /**
     * @return string
     */
    public function getZgIncomingData()
    {
        return $this->_Datastore['zgInc'];
    }

    /**
     * @return string
     */
    public function getUtTransferData()
    {
        return $this->_Datastore['ultraTransfers'];
    }

    /**
     * @param $booking_sql Booking\BookingSql
     * @param string $client
     * @return string
     */
    public function getEmailAdressForRyanair($booking_sql, $client = "vtoidach")
    {
        if (strtoupper($this->coreData->vt_fli_sv_airline) != 'FR') {
            return '';
        }

        $processno = trim($this->coreData->vt_fli_sv_processno);
        if ($processno == '-1' || !$processno) {
            return '';
        }

        if ($ryanair_email = $booking_sql->getRyanairEmail($processno)) {
            return $ryanair_email;
        }

        $booker = $this->_Datastore['participants'][0];

        setlocale(LC_CTYPE, 'de_DE.iso-8859-1');

        if (strtolower($client) == 'vto') {
            $tld = "vtours.de";
        } elseif (strtolower($client) == 'vtoidach' || strtolower($client) == 'vtoi') {
            $tld = "vtours.com";
        }

        $search = array(
            '–',
            '*',
            ',',
            ';',
            '_',
            ' ',
            '-',
            'dr.',
            '/dr',
            '/dr.',
            'prof.',
            '/prof',
            '/prof.',
            '\\',
            '/',
            '.'
        );

        $nachname = iconv('UTF-8', 'ASCII//TRANSLIT', str_replace($search, '', $booker->pa_name));
        $vorname = iconv('UTF-8', 'ASCII//TRANSLIT', str_replace($search, '', $booker->pa_firstname));

        setlocale(LC_CTYPE, "de_DE.UTF-8");

        $ryanair_email = strtolower($vorname . "." . $nachname . "." . $this->coreData->vt_bo_created2 . '@' . "fr." . $tld);
        $booking_sql->persistRyanairEmail($processno, $ryanair_email);
        return $ryanair_email;
    }

    /**
     * @return array
     */
    public function getHotelArray()
    {
        return $this->hotelArray;
    }
}
