<?php

namespace Vtours\Rula2Engine\Booking\Repository;

/**
 * *
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 * /
 */

use Vtours\Rula2Engine\SchedulerItem;

class BookingRepositoryManager
{

    private $table = "RULA2_PROZESS_MANAGER";
    private $pk = "RPM_ID";
    private $db;
    private $log;

    /**
     * @param $dataBaseConnection
     */
    public function __construct($dataBaseConnection, $logger)
    {
        $this->db = $dataBaseConnection;
        $this->log = $logger;
    }

    /**
     * @param SchedulerItem $prozessInformation
     * @return mixed
     */
    public function isProcessStartedOrNotFinish(SchedulerItem $prozessInformation)
    {

        $stmt = "select 
                    DISTINCT(1) 
				 from $this->table 
				 where P_ID = :prozessid 
				 and RSCI_START  = :prozessstart
				 and RSCI_DAY = :prozessday
				 and to_char(RPM_START,'YYYY-MM-DD') = '" . date('d.m.Y') . "'
				 and (RPM_FINISH = 1 OR RPM_ACTIVE = 1)";

        return $this->db->getAll(
            $stmt,
            [
                'prozessid' => $prozessInformation->getProcessId(),
                'prozessstart' => $prozessInformation->getStartTimeScheduler(),
                'prozessday' => $prozessInformation->getStartDayForScheduler()
            ]
        );
    }

    /**
     * @param array $data
     * @return bool
     * @throws Rulas2Exception
     */
    public function insertProcessToManagerTable($data)
    {
        if (is_array($data) && count($data) > 0) {
            return $this->db->autoexecute($this->table, $data, 'INSERT');
        }

        return false;
    }

    /**
     * @param array $data
     * @param SchedulerItem $obj
     * @return bool
     * @throws Rulas2Exception
     */
    public function updateProcessManagerTable($data, SchedulerItem $obj)
    {
        if (is_array($data) && count($data) > 0 && preg_match('/^[0-9]+$/', $obj->getId())) {
            return $this->db->autoexecute($this->table, $data, 'UPDATE', "$this->pk = " . $obj->getId());

        }
        return false;
    }

    /**
     * @throws Rulas2Exception
     */
    public function getDataBaseError()
    {
        if ($this->db->errorMsg()) {
            throw new Rulas2Exception(' Fehler im isProcessOrSchedulerRunning. MSG:: ' . $this->db->errorMsg());
        }
    }

    /**
     * @return integer
     * @throws Exception
     */
    public function getLastManagerIdFromSequence()
    {

        $stmt = "select 
                   (last_number)-1 
                 from user_sequences 
                 where sequence_name = :seqTable";

        $res = $this->db->getOne(
            $stmt,
            [
                'seqTable' => $this->table . '_SEQ'
            ]
        );

        $this->getDataBaseError();

        if ($res < 0) {
            throw new Rulas2Exception('Kann keine ID ermitteln. MSG::' . $this->db->errorMsg());
        }

        return $res;
    }

    /**
     * @param SchedulerItem $obj
     * @return bool
     * @throws Exception
     */
    public function updateDataBaseFlagsForFinishProcess(SchedulerItem $obj)
    {

        if (!preg_match('/^[0-9]+$/', $obj->getId())) {
            return false;
        }

        $rpm_id = $obj->getId();

        $stmt = "UPDATE $this->table set
				  rpm_finish = 1, 
				  rpm_active = 0
				 where $this->pk = :rpmid";

        $stat = $this->db->execute(
            $stmt,
            [
                'rpmid' => $rpm_id
            ]
        );
        $this->getDataBaseError();

        if (!$stat) {
            $message = 'Fehler im Update Managment. MSG::' . $this->db->errorMsg() . "--" . $stmt;
            throw new Rulas2Exception($message);
        }

    }

    /**
     * @param int $id
     * @return bool
     */
    public function getManagerDataById($id)
    {

        if (!$id) {
            return false;
        }

        $stmt = "select * from 
					 $this->table 
					 where $this->pk = :rpmid
					 and rpm_active = 1";

        return $this->db->getAll(
            $stmt,
            [
                'rpmid' => $id
            ]
        );
    }
}
