<?php

namespace Vtours\Rula2Engine;

/**
 * *
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 *
 */

class HtCategoryUtil
{
    /**
     * @var string
     */
    private $htCategory;

    /**
     * @param string $htCategory
     */
    public function __construct($htCategory)
    {
        $this->htCategory = $htCategory ? $htCategory : "";
    }

    /**
     * @return string
     */
    public function getAsStars()
    {
        $stars = '';
        if ($this->convertToNumber() == 0) {
            return $stars;
        }
        for ($i = 0; $i < $this->convertToNumber(); ++$i) {
            if ($i < $this->convertToNumber() - 1) {
                $stars .= '• ';
            } else {
                $stars .= '•';
            }
        }
        return $stars;
    }

    public function convertToNumber()
    {
        $lengthOfHtCategory = strlen($this->htCategory);
        if ($lengthOfHtCategory == 1) {
            return intval($this->htCategory);
        }
        return $this->convertToNumberFromHtCategoryWithDelimiter();
    }

    private function convertToNumberFromHtCategoryWithDelimiter()
    {
        $matches = array();
        preg_match('/(\d*,\d*)/', $this->htCategory, $matches);
        if (!empty($matches)) {
            $formattedNumberAsString = str_replace(",", ".", $matches[0]);
            $roundedNumberAsFloat = round(floatval($formattedNumberAsString), 0, PHP_ROUND_HALF_UP);
            return intval($roundedNumberAsFloat);
        }
        return 0;
    }
}
