<?php

namespace Vtours\Rula2Engine;

/**
 * *
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 *
 */

use stdClass;
use Exception;

class OptionsItem
{
    protected $pid;
    protected $ro_aktiv;
    protected $ro_id;
    protected $ro_name;
    protected $returnValue;
    public $isVariable;
    protected $isFromWebservice = false;
    protected $filenameForWebservice = '';
    public $isArray;
    public $bookingState = false;

    public function __get($name)
    {

        return $this->$name;
    }

    public function __set($name, $value)
    {
        if (!is_numeric($name)) {
            $this->$name = $value;
        }
    }

    public function getPid()
    {
        return $this->pid;
    }

    public function getOptionAktiv()
    {
        return $this->ro_aktiv;
    }

    public function getOptionId()
    {
        return $this->ro_id;
    }

    public function getOptionName()
    {
        return $this->ro_name;
    }

    public function startOption($data)
    {

        $return = array();
        try {
            if (strtolower($this->ro_name) === 'flugvoucher einbeziehen' && (int)$this->ro_aktiv == 1) {
                $file = new File();

                list($d, $m, $bookingYear) = explode(".", $data->coreData->vt_bo_created);
                $file->setBookingYear($bookingYear);
                $file->setBookingMonth($m);

                $files = $file->getUploadedFiles($data->coreData->vt_bo_id, 'flugvoucher');

                if (!is_array($files)) {
                    if ((\Zend_Registry::isRegistered('invoiceWithMail') && \Zend_Registry::get('invoiceWithMail') == true) ||
                        (\Zend_Registry::isRegistered('preview') && \Zend_Registry::get('preview') == true)) {
                        $files = $file->getUploadedFiles($data->coreData->vt_bo_id, 'flugvoucherProcessed');
                    }
                    if (!is_array($files)) {
                        return 'BREAK';
                    }
                }
                foreach ($files as $fileObj) {
                    if ($fileObj instanceof FileItem) {
                        $fileObj->returnValue = $fileObj->getContentOfFile();
                    } else {
                        throw new Exception('FileItem Objekt fehlerhaft');
                    }
                    $return[] = $fileObj;
                }

                return $return;
            }
            if (strtolower($this->ro_name) === 'vorgangsordner einbeziehen' && (int)$this->ro_aktiv == 1) {
                $file = new File();
                list($d, $m, $bookingYear) = explode(".", $data->coreData->vt_bo_created);
                $file->setBookingYear($bookingYear);
                $file->setBookingMonth($m);

                $files = $file->getUploadedFiles($data->coreData->vt_bo_id, 'booking');

                if (!is_array($files)) {
                    #$this->log->info('keine Dateien im Vorgangsordner vorhanden');
                    return;
                }
                foreach ($files as $fileObj) {
                    if ($fileObj instanceof FileItem) {
                        $fileObj->returnvalue = !$this->isFromWebservice || $this->filenameForWebservice != '' ? $fileObj->getContentOfFile() : null;
                    } else {
                        throw new Exception('FileItem Objekt fehlerhaft');
                    }
                    $return[] = $fileObj;
                }

                return $return;
            }
            if (strtolower($this->ro_name) == 'hash_id generieren' && (int)$this->ro_aktiv == 1) {
                $hashObj = new Rulas2_Hash_WriteHash();

                $val = $data->coreData->vt_bo_id . $data->coreData->vt_bo_customer_name . $data->coreData->vt_bo_customer_firstname . time() . rand(0,
                        99999999);

                if (!$this->isFromWebservice && !$this->bookingState) {
                    $hashObj->writeToDb('Rulas2', $data->coreData->vt_bo_id, $val, 'VT_HASH_TABLE');
                    $res = $hashObj->getHash('Rulas2', $data->coreData->vt_bo_id, 'VT_HASH_TABLE');
                }

                $this->returnValue = !empty($res) ? $res : 'Rula2_Hash_noch_nicht_generiert';
                $this->isVariable = 1;

                return $this;
            }
            if (strtolower($this->ro_name) == 'transferinformationen') {
                $transferInfo = new Booking_Transferinfo();
                $transferInfo->getTransferInfos($data->coreData->vt_bo_destination, $data->coreData->ht_transferagent);

                $temp = array();
                $temp['text'] = $transferInfo->getHtml();
                $temp['html'] = $transferInfo->getText();

                $this->returnValue = $temp;
                $this->isArray = 1;

                return $this;
            }
            if (strtolower($this->ro_name) == 'hinterlegungsschalter') {
                $schalterInfo = new Booking_Schalterinfo();
                $schalterInfo->getSchalterInfo($data->coreData->vt_fli_sv_airline,
                    $data->coreData->vt_fli_sv_departure);

                $temp = array();
                $temp['text'] = $schalterInfo->getText(); //utf8_decode($schalterInfo->getText());
                $temp['html'] = $schalterInfo->getHtml(); //utf8_decode($schalterInfo->getHtml());

                $this->returnValue = $temp;
                $this->isArray = 1;

                return $this;
            }
            if (strtolower($this->ro_name) == 'flugchecken' && !in_array($data->coreData->vt_bo_bookingtype,
                    array('E', 'B'))) {
                try {
                    foreach ($data->flighttimes as $value) {
                        $temp[] = $value->getData();
                    }
                    $check = new Toolbox_Flug_Check($temp);
                    $check->checkFlightData();
                } catch (Exception $e) {
                    \Zend_Registry::get('log')->info($e->getMessage());
                    return "BREAK";
                }
            }
            if (strtolower($this->ro_name) === 'checkin daten einbeziehen' && (int)$this->ro_aktiv == 1) {
                $urlTemp = \Zend_Registry::get('rulas2')->webservicePfad;
                $url = $urlTemp . "/tools/flightcheckin?vt_bo_id=" . $data->coreData->vt_bo_id . "&client=vto";

                $handle = curl_init($url);
                curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($handle, CURLOPT_POST, false);
                $tmp = curl_exec($handle);
                curl_close($handle);

                $data = json_decode($tmp);

                if ($data->status != 1 ||
                    !$data->data instanceof stdClass || $data == false) {
                    return false;
                }
                $tmpK = key($data->data);


                /*
                 * Muss zu einem Array umgewandelt werden wegen TinyMce
                 */

                if (is_array(!$data->data->$tmpK) && count($data->data->$tmpK) <= 0) {
                    return false;
                }

                foreach ($data->data->$tmpK as $key => $value) {
                    $tmpArray[$key] = $value;
                }

                $this->returnValue = $tmpArray;
                $this->isArray = true;
                return $this;
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
}
