<?php

namespace Vtours\Rula2Engine;

/**
 * *
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 * /
 */

/**
 * Class SchedulerItem
 */
class SchedulerItem
{
    protected $rsc_name;
    protected $rsc_info;
    protected $rsc_id;
    protected $rsc_insert;
    protected $rsc_update;
    protected $rsc_last_edit_user;
    protected $rsci_day;
    protected $rsci_start;
    protected $rsci_aktiv;
    protected $p_id;
    public $rpm_id;

    /**
     * @param string $name
     * @param string|int $value
     */
    public function __set($name, $value)
    {
        $name = strtolower($name);
        $this->$name = $value;
    }

    /**
     * @param string $name
     * @return string|int|null
     */
    public function __get($name)
    {
        if (isset($name)) {
            return $this->$name;
        } else {
            return null;
        }
    }

    /**
     * @return bool|string
     */
    public function checkItem()
    {

        $stat = FALSE;

        if ($this->rsci_day < 1 && $this->rsci_day > 10) {
            $stat = 'Error in Day';
        }

        if ($this->rsci_day != 9 && $this->rsci_day != 10 && !$this->timeCheck($this->rsci_start)) {
            $stat = 'Error in Time';
        }

        if (($this->rsci_day == 9 || $this->rsci_day == 10) && !$this->timeCheckMinutes($this->rsci_start)) {
            $stat = 'Error in Time (Minutes)';
        }

        if ($this->rsci_aktiv != 1) {
            $stat = 'Item not Active';
        }

        return $stat;
    }

    /**
     * @param string $time
     * @return bool
     */
    public function timeCheck($time)
    {

        if (!strstr($time, ':')) {
            return false;
        }

        $temp = explode(':', $time);

        if (
            ($temp[0] < 0 || $temp[0] > 24)
            || !preg_match('/^[0-9]{1,2}$/', $temp[0])
            || ($temp[1] < 0 || $temp[1] > 60)
            || !preg_match('/^[0-9]{1,2}$/', $temp[1])
        ) {
            return false;
        }

        return true;
    }

    /**
     * @param int $minutes
     * @return bool
     */
    public function timeCheckMinutes($minutes)
    {
        if ($minutes >= 0 && $minutes <= 59) {
            return true;
        }

        return false;
    }

    /**
     * @return int
     */
    public function getProcessId()
    {
        return $this->p_id;
    }

    /**
     * @return string
     */
    public function getStartTimeScheduler()
    {
        return $this->rsci_start;
    }

    /**
     * @return string
     */
    public function getStartDayForScheduler()
    {
        return $this->rsci_day;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->rpm_id;
    }
}
