<?php


use PHPUnit\Framework\TestCase;

include_once '..\HtCategoryUtil.php';

/**
 * Created by PhpStorm.
 * User: s.nagel
 * Date: 03.07.2018
 * Time: 15:23
 */
class HtCategoryUtilTest extends TestCase
{
    public function testConvertToNumber()
    {
        $util = new HtCategoryUtil('1');
        self::assertEquals(1, $util->convertToNumber());

        $util = new HtCategoryUtil('1,4');
        self::assertEquals(1, $util->convertToNumber());

        $util = new HtCategoryUtil('1,4+');
        self::assertEquals(1, $util->convertToNumber());

        $util = new HtCategoryUtil('1,6+');
        self::assertEquals(2, $util->convertToNumber());

        $util = new HtCategoryUtil('2,1- ');
        self::assertEquals(2, $util->convertToNumber());

        $util = new HtCategoryUtil('  2,5  ');
        self::assertEquals(3, $util->convertToNumber());
    }

    public function testOneSingleStar()
    {
        $util = new HtCategoryUtil('1');
        self::assertEquals('*', $util->getAsStars());
    }

    public function test5Stars()
    {
        $util = new HtCategoryUtil('5,1+');
        self::assertEquals('* * * * *', $util->getAsStars());
    }

    public function testNoStars()
    {
        $util = new HtCategoryUtil(null);
        self::assertEmpty($util->getAsStars());
    }
}
