<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */


include_once '/data1/_Framework/Rula2Engine/Service/MobilePhoneCleanerAndValidator.php';

use PHPUnit\Framework\TestCase;

/**
 * Class MobilePhoneCleanerAndValidatorTest
 * @package ${NAMESPACE}
 */
class MobilePhoneCleanerAndValidatorTest extends TestCase
{
    public function testTest()
    {
        $this->assertTrue(true);
    }

    public function testIsGermanMobileNumber()
    {
        $obj = new MobilePhoneCleanerAndValidator();
        $this->assertTrue($obj->isGermanMobilePhoneNumber('017621190775'));
        $this->assertTrue($obj->isGermanMobilePhoneNumber('004917621190775'));
        $this->assertTrue($obj->isGermanMobilePhoneNumber('04917621190775'));
        $this->assertTrue($obj->isGermanMobilePhoneNumber('+4917621190775'));
        $this->assertTrue($obj->isGermanMobilePhoneNumber('17621190775'));
    }

    public function testIsNotGermanMobileNumber()
    {
        $obj = new MobilePhoneCleanerAndValidator();
        $this->assertFalse($obj->isGermanMobilePhoneNumber('07621190775'));
        $this->assertFalse($obj->isGermanMobilePhoneNumber('041017621190775'));
        $this->assertFalse($obj->isGermanMobilePhoneNumber('043017621190775'));
    }

    public function testIsAustrianMobileNumber()
    {
        $obj = new MobilePhoneCleanerAndValidator();
        $this->assertTrue($obj->isAustrianMobilePhoneNumber('04365119077534'));
        $this->assertTrue($obj->isAustrianMobilePhoneNumber('004365119077534'));
        $this->assertTrue($obj->isAustrianMobilePhoneNumber('043 6511 907 7534'));
        $this->assertTrue($obj->isAustrianMobilePhoneNumber('+4365934343434'));
        $this->assertTrue($obj->isAustrianMobilePhoneNumber('04369323232322'));
        $this->assertTrue($obj->isAustrianMobilePhoneNumber('043-69-323232322'));
        $this->assertTrue($obj->isAustrianMobilePhoneNumber('069323232322'));
    }

    public function testIsNotAustrianMobileNumber()
    {
        $obj = new MobilePhoneCleanerAndValidator();
        $this->assertFalse($obj->isAustrianMobilePhoneNumber('07621190775'));
        $this->assertFalse($obj->isAustrianMobilePhoneNumber('041017621190775'));
        $this->assertFalse($obj->isAustrianMobilePhoneNumber('043017621190775'));
    }

    public function testIsSwitzerLandMobileNumber()
    {
        $obj = new MobilePhoneCleanerAndValidator();
        $this->assertTrue($obj->isSwitzerlandMobilePhoneNumber('04176119077534'));
        $this->assertTrue($obj->isSwitzerlandMobilePhoneNumber('004176119077534'));
        $this->assertTrue($obj->isSwitzerlandMobilePhoneNumber('041 7711 907 7534'));
        $this->assertTrue($obj->isSwitzerlandMobilePhoneNumber('07611 907 7534'));
        $this->assertTrue($obj->isSwitzerlandMobilePhoneNumber('7611 907 7534'));
        $this->assertTrue($obj->isSwitzerlandMobilePhoneNumber('+4179934343434'));
        $this->assertTrue($obj->isSwitzerlandMobilePhoneNumber('04179323232322'));
        $this->assertTrue($obj->isSwitzerlandMobilePhoneNumber('041-78-323232322'));
        $this->assertTrue($obj->isSwitzerlandMobilePhoneNumber('079323232322'));
    }

    public function testIsNotSwitzerLandMobileNumber()
    {
        $obj = new MobilePhoneCleanerAndValidator();
        $this->assertFalse($obj->isAustrianMobilePhoneNumber('07621190775'));
        $this->assertFalse($obj->isAustrianMobilePhoneNumber('041017621190775'));
        $this->assertFalse($obj->isAustrianMobilePhoneNumber('043017621190775'));
    }

    public function testGermanNumberIsClean()
    {
        $obj = new MobilePhoneCleanerAndValidator();

//        $this->assertEquals($obj->getCleanGermanNumber('04917621190775'), '4917621190775');
//        $this->assertEquals($obj->getCleanGermanNumber('+4917621190775'), '4917621190775');
//        $this->assertEquals($obj->getCleanGermanNumber('4917621190775'), '4917621190775');
//        $this->assertEquals($obj->getCleanGermanNumber('017621190775'), '4917621190775');
//        $this->assertEquals($obj->getCleanGermanNumber('17621190775'), '4917621190775');
//        $this->assertEquals($obj->getCleanGermanNumber('1762110490775'), '491762110490775');
//        $this->assertEquals($obj->getCleanGermanNumber('0491762110490775'), '0491762110490775');
//        $this->assertEquals($obj->getCleanGermanNumber('0491762110490775'), '0491762110490775');
//        $this->assertEquals($obj->getCleanGermanNumber('1762110490775'),'0491762110490775');

        $this->assertEquals($obj->getCleanGermanNumber('+491737734628'),'491737734628');

//        $this->assertFalse($obj->getCleanGermanNumber('0431762110490775'));
    }

    public function testAustrianNumberIsClean()
    {
        $obj = new MobilePhoneCleanerAndValidator();

        $this->assertEquals($obj->getCleanAustrianNumber('04365021190775'), '04365021190775');
        $this->assertEquals($obj->getCleanAustrianNumber('+4369021190775'), '4369021190775');
        $this->assertEquals($obj->getCleanAustrianNumber('436681190775'), '436681190775');
        $this->assertEquals($obj->getCleanAustrianNumber('4366521190775'), '4366521190775');
        $this->assertEquals($obj->getCleanAustrianNumber('66921190775'), '4366921190775');
        $this->assertEquals($obj->getCleanAustrianNumber('672110490775'), '43672110490775');
        $this->assertEquals($obj->getCleanAustrianNumber('06602110490775'), '436602110490775');
        $this->assertEquals($obj->getCleanAustrianNumber('043692110490775'), '43692110490775');
        $this->assertEquals($obj->getCleanAustrianNumber('069110490775'),'4369110490775');
        $this->assertFalse($obj->getCleanAustrianNumber('0411762110490775'));
    }

    public function testSwitzerLandNumberIsClean()
    {

        // after Countrycode no null has to come , eliminate 0


        $obj = new MobilePhoneCleanerAndValidator();

        $this->assertEquals($obj->getCleanSwitzerLandNumber('0417621190775'), '417621190775');
        $this->assertEquals($obj->getCleanSwitzerLandNumber('+417621190775'), '417621190775');
        $this->assertEquals($obj->getCleanSwitzerLandNumber('417621190775'), '417621190775');
        $this->assertEquals($obj->getCleanSwitzerLandNumber('07621190775'), '417621190775');
        $this->assertEquals($obj->getCleanSwitzerLandNumber('7621190775'), '417621190775');
        $this->assertEquals($obj->getCleanSwitzerLandNumber('762110490775'), '41762110490775');
        $this->assertEquals($obj->getCleanSwitzerLandNumber('041762110490775'), '41762110490775');
        $this->assertEquals($obj->getCleanSwitzerLandNumber('0410792110490775'), '41792110490775');
        $this->assertEquals($obj->getCleanSwitzerLandNumber('762110490775'),'41762110490775');
        $this->assertFalse($obj->getCleanSwitzerLandNumber('0491762110490775'));
    }
}
