<?php

namespace Vtours\Rula2Engine;

/**
 * *
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 *
 */

use Exception;

class TemplateItem {

	public $rt_id;
	public $rt_name;
	public $rt_titel;
	public $rt_dokutyp;
	public $rt_emailtyp;
	public $rt_html;
	public $rt_text;
	public $rt_inserttime;
	public $rt_updatetime;
	public $rt_last_edit_user;
	public $rt_info;
	public $template = null;
	public $rt_ext;
	public $rt_dontset_border;

	protected $tpl = '';

	
	public function tinyCss($display = false) {
		$css = file_get_contents(dirname(__FILE__) . "/Booking/Templates/pdf.css");
		if ($display) {
			header("Content-type: text/css", true);
			header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
			header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
			header('Cache-Control: no-store, no-cache, must-revalidate');
			header('Cache-Control: pre-check=0, post-check=0, max-age=0');
			header("Pragma: no-cache");
			echo $css;
			return;
		}
		else
			return $css;
	}

	public function __construct($data) {
		if(!is_array($data)) { return; }
		
		foreach ($data as $key => $value) {
			if(!is_numeric($key)){
				$temp = strtolower($key);
				$this->$temp = stripslashes($value);
			}
		}
	}
	
	public function setGeneratedTemplate($tpl){
		$this->template = $tpl;
	}
	
	public function getGeneratedTemplate(){
		return $this->template;
	}
	
	public function checkIfItsAttachment(){
	
		if(strtolower($this->rt_dokutyp) == 'anhang') return True;
		else return False;
	
	}
	
	public function isTemplateVariable(){
		return strtolower($this->rt_emailtyp) == 'variable' ? true : false; 
	}
	
	public function isProzessVariable(){
		return strtolower($this->rt_emailtyp) == 'pvariable' ? true : false; 
	}
	
	public function checkIfItsMailContent(){
		
		if(strtolower($this->rt_dokutyp) == 'mailcontent') return True;
		else return False;
		
	}

	public function checkIfItsSMSContent(){
		return (strtolower($this->rt_dokutyp) === 'sms') ? true : false;

	}
	
	public function setContent(){
		try{
			
			if(strtolower($this->rt_emailtyp) == 'pdf'){
			
				$anfrage = WebserviceAccounting::getInstance('cli');
				
				if(!$anfrage instanceof WebserviceAccounting) throw new Exception('Webservice um PDF zu erstellen ist fehlerhaft');
				
				$data['htmlstring'] = $this->preparePdfTemplate(trim($this->template));

				if($this->rt_dontset_border == 1){
                    $data['pdfmargin'] = 0;
				} else {
                    $data['pdfmargin'] = 10;
                }

				$res = $anfrage->request($data ,'pdf');
				
				if(trim($res->getBody()) != null || trim($res->getBody()) != '') $this->template = $res->getBody();
				
				$this->rt_ext = 'pdf';
				
				$this->setMimeType();
				
			}
			
			return $this;
			
		}catch(Exception $e){
			throw new Exception($e->getMessage());
		}
	}
	
	public function setMimeType() {
		$mime = array(
			'csv'			=> 'text/csv',
			'doc'			=> 'application/msword',
			'docx'		=> 'application/msword',
			'gif'			=> 'image/gif',
			'jpg'			=> 'image/jpeg',
			'jpeg'		=> 'image/jpeg',
			'pdf'			=> 'application/pdf',
			'png'			=> 'image/png',
			'rtf'			=> 'text/richtext',
			'xls'			=> 'application/x-msexcel',
			'xml'			=> 'text/xml',
			'txt'			=> 'text/plain'
		);
		
		if(!isset($mime[$this->rt_ext])) {
			$this->rt_emailtyp = 'text/plain';
		}
		else {
			$this->rt_emailtyp = $mime[$this->rt_ext];
		}
	}
	
	public function preparePdfTemplate($content){
		
		try{
			#$temp.= "<style>";
			#$temp.= $this->tinyCss(false);
			#$temp .= "</style>";
			#$temp.= "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
			#$temp.= "<html><head><title></title><meta http-equiv=Content-Type content=\"text/html; charset=utf-8\"></head>";
			#$temp.= $content;
			#$temp.= "</body></html>";			
			return $content;
		}catch(Exception $e){
			
		}
		
	}
}

?>
