<?php

namespace Vtours\Rula2Engine;

/**
 * *
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 *
 */

use Exception;

class Rmail extends Rula2Std
{

    public $mail;
    public $log;
    public $db;
    public $ini;

    public function __construct(&$log = null, $host= null , $config = null, $from = null)
    {

        if($from == 'app' && $host != null && $config != null) {
            if (!is_null(Zend_Mail::getDefaultTransport())) {
                Zend_Mail::clearDefaultTransport();
            }

            $tr = new Zend_Mail_Transport_Smtp(
                $host,
                $config);

            Zend_Mail::setDefaultTransport($tr);
            $this->mail = new Zend_Mail('UTF-8');
            \Zend_Registry::get('log')->info('Erfogreich erzeugt SMTP handler '.$host.'  '.print_r($config,1));

        } else {

            $this->mail = new Zend_Mail('UTF-8');
        }

        parent::init();

        if ($log) {
            $this->log = $log;
        }
    }

    public function addTO($email)
    {
        try {

            $to = $this->getArrayFromString($email);
            if (!is_array($to) && $this->checkEmails($to)) {
                $this->mail->addTo($to);
                $this->log->info('Folgender Email Empfaenger::' . $to);
            } else {
                $emails = $this->checkEmails($to);
                if (!$emails) {
                    throw new Exception('Kein Empfaenger(TO) breche den Versand ab');
                } else {
                    foreach ($emails as $email) {
                        $this->mail->addTo($email);
                        $this->log->info('Folgender Email Empfaenger::' . $email);
                    }
                }
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
        return true;
    }

    public function addBcc($bcc)
    {
        try {

            $bcc = str_replace('BCC:', '', $bcc);
            if ($bcc == null || $bcc == '') {
                return true;
            }
            $to = $this->getArrayFromString($bcc);
            if (!is_array($to) && $this->checkEmails($to)) {
                $this->mail->addbcc($to);
                $this->log->info('Folgender Email Empfaenger (BCC)::' . $to);
            } else {
                foreach ($to as $email) {
                    if ($this->checkEmails($email)) {
                        $this->mail->addBcc($email);
                        $this->log->info('Folgender Email Empfaenger (BCC)::' . $email);
                    }
                }
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
        return true;
    }

    public function addCc($cc)
    {
        try {

            $cc = str_replace('CC:', '', $cc);
            if ($cc == null || $cc == '') {
                return true;
            }
            $to = $this->getArrayFromString($cc);
            if (!is_array($to) && $this->checkEmails($to)) {
                $this->mail->addCc($to);
                $this->log->info('Folgender Email Empfaenger (CC)::' . $to);
            } else {
                foreach ($to as $email) {
                    if ($this->checkEmails($email)) {
                        $this->mail->addCc($email);
                        $this->log->info('Folgender Email Empfaenger (CC)::' . $to);
                    }
                }
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
        return true;
    }

    public function getArrayFromString($string)
    {

        if (stristr($string, ',')) {
            return explode(',', $string);
        } elseif (stristr($string, ';')) {
            return explode(';', $string);
        } else {
            return $string;
        }
    }

    public function checkEmails($emails)
    {

        $validate = new Zend_Validate_EmailAddress();

        if (!is_array($emails)) {

            if ($validate->isValid($emails)) {
                $this->log->info('Email Adresse :' . $emails . ' ist ok');
                return true;
            } else {
                $this->log->err('Email Adresse :' . $emails . ' nicht ok');
                return false;
            }
        } else {
            $emailsToSend = array();

            foreach ($emails as $email) {

                if ($validate->isValid($email)) {
                    $this->log->info('Email Adresse :' . $email . ' ist ok');
                    $emailsToSend[] = $email;
                } else {
                    $this->log->err('Email Adresse :' . $email . ' nicht ok');
                    continue;
                }
            }

            if (count($emailsToSend) > 0) {
                return $emailsToSend;
            } else {
                return false;
            }
        }
    }

    public function setBodyContent($content, $typ)
    {
        #__print($content);
        try {
            if ($typ == 'html') {
                $this->mail->setBodyHtml($content);
            } elseif ($typ == 'text') {
                $this->mail->setBodyText($content);
            } else {
                $this->mail->setBodyHtml($content);
            }

            return true;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function setSubject($subject)
    {

        try {

            $this->mail->setSubject($subject);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function send()
    {
        try {

            $stat = $this->mail->send();
            if ($stat) {
                $this->log->info('Email erfolgreich versendet');
            } else {
                throw new Exception('Fehler beim versand der Mail');
            }

            return true;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function setFrom($email)
    {

        if ($email == null || $email == '') {
            $email = $this->ini->email_from;
            \Zend_Registry::get('log')->info('Keine Email vorhanden (From). Nehme mail aus der Ini');
        }

        $validate = new Zend_Validate_EmailAddress();

        if ($validate->isValid($email)) {
            $this->mail->setFrom($email);
        } else {
            throw new Exception('Fehlerhafte From Adresse');
        }

        \Zend_Registry::get('log')->info('from mail ::' . $email);
    }

    public function addAttachments($attaches, $data)
    {
        try {
            $pattern = null;

            foreach ($attaches as $id => $obj) {

                $pattern = '/[.]{1}[a-zA-Z0-9]{1,3}$/';
                if (!preg_match($pattern, $obj->rt_titel)) {
                    $obj->rt_titel = $obj->rt_titel . '.' . $obj->rt_ext;
                }
                $pattern = '/[\[\{]{2}[0-9a-zA-Z$_ ]+[\}\]]{2}/';
                preg_match_all($pattern, $obj->rt_titel, $array);
                foreach ($array[0] as $value) {
                    $temp = str_replace(array('[', '{', '}', ']', '$'), '', $value);

                    if ($temp == 'vt_customer_name' || $temp == 'vt_customer_firstname' || $temp == 'vt_customer_salutation') {

                        $booker = $data->getBookerData();

                        /*
                          if (substr($temp, 0, 5) == 'vt_bo') {//Weiss net wer sich das ausgedacht hat. Muss jetzt drum rum bauen. NB
                          $temp = str_replace('_bo', '', $temp);
                          } */

                        $obj->rt_titel = str_replace($value, $booker->$temp, $obj->rt_titel);
                    } elseif ($data->coreData->$temp != null && $data->coreData->$temp != '') {
                        $pattern = '/[0-9]{2,4}[-]{1}[0-9]{1,2}[-]{1}[0-9]{1,2}/';
                        if (preg_match($pattern, $data->coreData->$temp)) {
                            $data->coreData->$temp = $this->changeDate($data->coreData->$temp);
                        }
                        $obj->rt_titel = str_replace($value, $data->coreData->$temp, $obj->rt_titel);
                    }
                }
                if ($obj instanceof TemplateItem) {

                    $this->mail->createAttachment($obj->template, $obj->rt_emailtyp, Zend_Mime::DISPOSITION_ATTACHMENT, Zend_Mime::ENCODING_BASE64, $obj->rt_titel);
                    //$obj->rt_titel.'.'.$obj->rt_ext);
                    $this->log->info('DISPOSITION_ATTACHMENT');
                    $this->log->info('Folgende Attaches hinzu::' . strtolower($obj->rt_titel));
                } else {
                    throw new Exception('Kein Item');
                }
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    public function getSubject($subject, $data)
    {
        $array = null;
        try {
            $pattern = '/[\[\{]{2}[0-9a-zA-Z$_ ]+[\}\]]{2}/';
            preg_match_all($pattern, $subject, $array);

            foreach ($array[0] as $value) {

                $temp = str_replace(array('[', '{', '$', '}', ']'), '', $value);
                if ($temp == 'vt_customer_name' || $temp == 'vt_customer_firstname' || $temp == 'vt_customer_salutation') {

                    $booker = $data->getBookerData();
                    /*
                      if (substr($temp, 0, 5) == 'vt_bo') {//Weiss net wer sich das ausgedacht hat. Muss jetzt drum rum bauen. NB
                      $temp = str_replace('_bo', '', $temp);
                      } */
                    $subject = str_replace($value, $booker->$temp, $subject);
                } elseif ($data->coreData->$temp != null && $data->coreData->$temp != '') {
                    $pattern = '/[0-9]{2,4}[-]{1}[0-9]{1,2}[-]{1}[0-9]{1,2}/';
                    if (preg_match($pattern, $data->coreData->$temp)) {
                        $data->coreData->$temp = $this->changeDate($data->coreData->$temp);
                    }
                    $subject = str_replace($value, $data->coreData->$temp, $subject);
                }
            }

            return $subject;
        } catch (Exception $e) {
            throw new Exception('Fehler beim aendern des Subjects');
        }
    }

    public function changeDate($date)
    {

        $temp = explode('-', $date);

        return $temp[2] . "." . $temp[1] . "." . $temp[0];
    }

}
