<?php

namespace Vtours\Rula2Engine\Booking;

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */


use Vtours\Rula2Engine\Extendablemagic;


class BookingCustomer extends Extendablemagic
{

    /**
     * @var string
     */
    protected $_convert_keys = 'all';


    public function __construct()
    {

        $this->_Datastore = array(
            'vt_customer_salutation' => '',
            'vt_customer_name' => '',
            'vt_customer_firstname' => '',
            'vt_customer_street' => '',
            'vt_customer_country' => '',
            'vt_customer_zipcode' => '',
            'vt_customer_city' => '',
        );

    }

    /**
     * @param $key
     * @param $val
     * @return void
     */
    public function __set($key, $val)
    {
        if (!array_key_exists($key, $this->_Datastore)) {
            return;
        }
        $this->_Datastore[$key] = $val;
    }
}
