<?php

namespace Vtours\Rula2Engine\Booking;


/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

class BookingSqlConfig
{

    private $vt_bookings;
    private $vt_hotels;
    private $vt_flight_saved;
    private $vt_history;
    private $vt_reclamation;
    private $vt_rulas_send;
    private $vt_reclamation_refund;
    private $vt_reclamation_coupon;
    private $vt_bookings_parameter;
    private $vt_cc_guwid;
    private $vt_eft_invalid;
    private $vt_flights_first;
    private $vt_dunnings;
    private $vt_bookings_checkin;
    private $zahlungs_import;
    private $exchange_rates_list;
    private $client;

    /**
     * @param string $client
     */
    public function setConfigDataForCoreSelect($client)
    {

        $this->client = $client;
        $this->set_vt_bookings();
        $this->set_vt_hotels();
        $this->set_vt_flight_saved();
        $this->set_vt_bookings_parameter();
        $this->set_vt_cc_guwid();
        $this->set_vt_reclamation();
        $this->set_vt_reclamation_refund();
        $this->set_vt_reclamation_coupon();
        $this->set_vt_eft_invalid();
        $this->set_vt_rulas_send();
        $this->set_vt_history();
        $this->set_vt_flights_first();
        $this->set_vt_dunnings();
        $this->set_vt_bookings_checkin();
        $this->set_boni_data();
        $this->set_zahlungsimport();
        $this->set_exchange_rates();
    }

    /**
     * @return string
     */
    public function get_vt_bookings()
    {
        return $this->vt_bookings;
    }

    /**
     * @return string
     */
    public function get_vt_hotels()
    {
        return $this->vt_hotels;
    }

    /**
     * @return string
     */
    public function get_vt_flight_saved()
    {
        return $this->vt_flight_saved;
    }

    /**
     * @return string
     */
    public function get_vt_bookings_parameter()
    {
        return $this->vt_bookings_parameter;
    }

    /**
     * @return string
     */
    public function get_vt_cc_guwid()
    {
        return $this->vt_cc_guwid;
    }

    /**
     * @return string
     */
    public function get_vt_reclamation()
    {
        return $this->vt_reclamation;
    }

    /**
     * @return string
     */
    public function get_vt_reclamation_refund()
    {
        return $this->vt_reclamation_refund;
    }

    /**
     * @return string
     */
    public function get_vt_reclamation_coupon()
    {
        return $this->vt_reclamation_coupon;
    }

    /**
     * @return string
     */
    public function get_vt_eft_invalid()
    {
        return $this->vt_eft_invalid;
    }

    /**
     * @return string
     */
    public function get_vt_rulas_send()
    {
        return $this->vt_rulas_send;
    }

    /**
     * @return string
     */
    public function get_vt_history()
    {
        return $this->vt_history;
    }

    /**
     * @return string
     */
    public function get_vt_flights_first()
    {
        return $this->vt_flights_first;
    }

    /**
     * @return string
     */
    public function get_vt_dunnings()
    {
        return $this->vt_dunnings;
    }

    /**
     * @return string
     */
    public function get_vt_bookings_checkin()
    {
        return $this->vt_bookings_checkin;
    }

    /**
     * @return string
     */
    public function get_boni_data()
    {
        return $this->boni_data;
    }

    /**
     * @return string
     */
    public function get_zahlungs_import()
    {
        return $this->zahlungs_import;
    }


    private function set_vt_bookings()
    {

        $this->vt_bookings = "(SELECT NVL(COUNT(FLI_BO_ID),'0') FROM VT_FLIGHTS WHERE FLI_BO_ID = b.VT_BO_ID) as vt_fli_flight_seqments," .
            "case when (select distinct(1) from vt_pricecorrections vtp
							 where vtp.vt_price_correctiontype = 'UNISTER' and vtp.VT_BO_ID = b.VT_BO_ID) = 1
                        THEN 1
			ELSE 0
		END as PC_UNISTER," .
            "(SELECT DISTINCT(1) FROM VT_FLIGHTS WHERE FLI_BO_ID = b.VT_BO_ID) as FLUGZEITEN," .
            "(SELECT DISTINCT(1) FROM ZAHLUNGSIMPORT_ITEM zisub  WHERE zisub.vt_bo_id = b.vt_bo_id and zisub.fortnr is null) as ZAHLUNGS_VORMERKUNG," .
            "(SELECT DISTINCT(1) FROM VT_FLIGHTS WHERE FLI_BO_ID = b.VT_BO_ID 
                AND trim(SUBSTR(FLI_FLIGHTAIRLINE ,REGEXP_INSTR(FLI_FLIGHTAIRLINE,'[,]') +1)) = 'X3') as X3_INFLIGHT," .
            "(SELECT DISTINCT(1) FROM VT_FLIGHTS WHERE FLI_BO_ID = b.VT_BO_ID 
                AND trim(SUBSTR(FLI_FLIGHTAIRLINE ,REGEXP_INSTR(FLI_FLIGHTAIRLINE,'[,]') +1)) = 'DE') as DE_INFLIGHT," .
            "(select to_char(vtrr_insert_on,'dd.mm.YYYY')
			from vt_reclamation_reasons where b.vt_bo_id = vtrr_bo_id and vtrr_no = 0) as Eingangen_am," .
            "b.vt_bo_id," .
            "b.vt_bo_storno," .
            "b.vt_bo_agencyno," .
            "case when b.VT_BO_PAYMETHOD = 'K' and TO_CHAR(b.VT_BO_CREATED,'YYYY-MM-DD') < '2013-07-01' and '$this->client' not in ('xlow','vfly')
			THEN 
                            CASE 
                            when (b.vt_bo_cc_entgelt is null OR b.vt_bo_cc_entgelt = '' OR b.vt_bo_cc_entgelt <= 0) AND b.VT_BO_TOTALPRICE < 1000
				THEN '5'
				when (b.vt_bo_cc_entgelt is null OR b.vt_bo_cc_entgelt = '' OR b.vt_bo_cc_entgelt <= 0) AND b.VT_BO_TOTALPRICE >= 1000
				THEN '10'
                            ELSE to_char(b.vt_bo_cc_entgelt)
                            END
                            when b.VT_BO_PAYMETHOD = 'K' and TO_CHAR(b.VT_BO_CREATED,'YYYY-MM-DD') >= '2013-07-01' and b.VT_ENTGELTSATZ is not null
                                THEN 
                                    TO_CHAR(ROUND(b.VT_BO_TOTALPRICE * b.VT_ENTGELTSATZ,2))
				ELSE 
                                    null
                END as vt_bo_cc_entgelt," .
            " trunc(vt_bo_beginn) - trunc(vt_bo_created) ," .
            " CASE WHEN trunc(b.vt_bo_beginn) - trunc(b.vt_bo_created) > 30
			THEN '0'
			WHEN trunc(b.vt_bo_beginn) - trunc(b.vt_bo_created) <= 30
			THEN '1'
                END as vt_bo_shortbooking," .
            "TO_CHAR(b.VT_BO_CREATED,'DD.MM.YYYY') as VT_BO_CREATED," .
            "TO_CHAR(b.VT_BO_LAST_UPDATE,'DD.MM.YYYY') as VT_BO_LAST_UPDATE," .
            "TO_CHAR(b.VT_BO_CREATED,'DDMMYYYY') as VT_BO_CREATED2," .
            "TO_CHAR(b.vt_bo_beginn,'DD.MM.YYYY') as VT_BO_BEGINN," .
            "b.VT_BO_DURATION," .
            "TO_CHAR(b.VT_BO_BEGINN + b.VT_BO_DURATION,'DD.MM.YYYY') as VT_BO_END," .
            "to_char(b.vt_bo_beginn,'YYYYMMDD') as beginnts ," .
            "b.vt_bo_destination," .
            "b.vt_bo_bookingtype," .
            "b.vt_bo_bookingaction," .
            "b.VT_BO_FLIGHTTICKET," .
            "b.VT_BO_CUSTCALCULATION," .
            "CASE b.VT_BO_CASHING
			WHEN 'DIK' THEN '0'
			ELSE '1'
                END as VT_BO_RIK," .
            "b.VT_BO_PREPAYMENT," .
            "b.vt_bo_servicecharge," .
            "to_char(b.VT_BO_CUSTCALCULATIONDATE,'dd.mm.YYYY') as VT_BO_CUSTCALCULATIONDATE," .
            "to_char(b.VT_BO_PREPAYMENT_DUE,'dd.mm.YYYY') as VT_BO_PREPAYMENT_DUE," .
            "to_char(b.VT_BO_BALANCEPAYMENT_DUE,'dd.mm.YYYY') as VT_BO_BALANCEPAYMENT_DUE," .
            "b.VT_BO_INTERNALBOOKINGCONDITION," .
            "b.VT_BO_TRAVELDOCUMENTS," .
            "b.VT_BO_STORNOSEND," .
            "b.VT_BO_BILL_RESEND," .
            "b.VT_BO_TRANSFERCONFIRMED," .
            "b.VT_BO_PAYMETHOD," .
            "b.VT_BO_HOTELCONFIRMED," .
            "b.VT_BO_OPTION," .
            "b.vt_bo_balancepayment," .
            "b.vt_bo_internaltreatmentconditi," .
            "b.vt_bo_customer_email," .
            "to_char(vt_bo_totalprice,'99999999,00') as vt_bo_totalprice_k, " .
            "to_char(vt_bo_prepayment_amount,'99999999,00') as vt_bo_prepayment_amount_k," .
            "to_char(vt_bo_balancepayment_amount,'99999999,00') as vt_bo_balancepayment_amount_k," .
            "to_char(vt_bo_totalprice,'99999999.00') as vt_bo_totalprice, " .
            "to_char(vt_bo_prepayment_amount,'99999999.00') as vt_bo_prepayment_amount," .
            "to_char(vt_bo_prepaymentdate,'dd.mm.YYYY') as vt_bo_prepaymentdate," .
            "to_char(vt_bo_balancedate,'dd.mm.YYYY') as vt_bo_balancedate," .
            "to_char(vt_bo_balancepayment_amount,'99999999.00') as vt_bo_balancepayment_amount," .
            "to_char((b.vt_bo_totalprice + NVL(AZ_ENTGELT, 0) + NVL(RZ_ENTGELT ,0) ) - (NVL(b.vt_bo_prepayment_amount_real,0) + NVL(b.vt_bo_balancepayment_amt_real,0)),'99999999.00') as vt_bo_payment_ges_open," .
            "to_char(vt_bo_balancepayment_amt_real,'99999999.00') as vt_bo_balancepayment_amt_real," .
            "to_char(vt_bo_prepayment_amount_real,'99999999.00') as vt_bo_prepayment_amount_real," .
            "INITCAP(b.vt_bo_customer_name) as vt_bo_customer_name," .
            "INITCAP(b.vt_bo_customer_firstname) as vt_bo_customer_firstname," .
            "to_char(b.vt_bo_reclamation_date,'DD.MM.YYYY') as vt_bo_reclamation_date," .
            "b.vt_bo_reclamation," .
            "b.vt_bo_ba_agname AS vt_bo_ba_agname_, " .
            "(select vt_ag_firmenname from vt_agencies where vt_bo_agencyno = vt_ag_agenturnr) as vt_bo_ba_agname, " .
            "(select distinct(1) 
                from vt_pricecorrections vpc 
                where vpc.vt_bo_id = b.vt_bo_id 
                and vt_price_correctiontype = 'WASSERFLUGZEUG' 
             ) as PC_WATER_PLANE ," .
            " case when vt_bo_client = 'ULTRA' then 
                (select usr_email from user_auth where usr_agenturnr = to_char(vt_bo_agencyno) and usr_active = 1)
                else b.VT_BO_BA_AGEMAIL 
                END as VT_BO_BA_AGEMAIL," .
            " case when vt_bo_client = 'ULTRA' then 
                (select vt_ag_fax from vt_agencies where vt_ag_agenturnr = to_char(vt_bo_agencyno))
                else b.VT_BO_BA_AGFAX 
                END as VT_BO_BA_AGFAX ," .
            " case when vt_bo_client = 'ULTRA' then 
                (select CONCAT(VT_AG_TEL_VORW,CONCAT(' - ',vt_ag_telefon)) from vt_agencies where vt_ag_agenturnr = to_char(vt_bo_agencyno))
                else b.VT_BO_BA_AGTELEPHONE 
                END as VT_BO_BA_AGTELEPHONE," .
            " case when vt_bo_client = 'ULTRA' then 
                (select vt_ag_stadt from vt_agencies where vt_ag_agenturnr = to_char(vt_bo_agencyno))
                else b.VT_BO_BA_AGCITY 
                END as VT_BO_BA_AGCITY ," .
            " case when vt_bo_client = 'ULTRA' then 
                (select vt_ag_plz from vt_agencies where vt_ag_agenturnr = to_char(vt_bo_agencyno))
                else b.VT_BO_BA_AGZIP 
                END as VT_BO_BA_AGZIP," .
            " case when vt_bo_client = 'ULTRA' then 
                (select vt_ag_strasse from vt_agencies where vt_ag_agenturnr = to_char(vt_bo_agencyno))
                else b.VT_BO_BA_AGSTREET 
                END as VT_BO_BA_AGSTREET," .
            "b.VT_BO_BA_AGMOBILE," .
            "b.vt_bo_internaldescr," .
            "b.vt_bo_customer_firstname||' '||b.vt_bo_customer_name as vt_bo_customer_gname ," .
            "b.vt_bo_transferprice," .
            "b.vt_bo_stopruladispatch, " .
            "b.vt_bo_customer_address as vt_bo_customer_salutation," .
            "b.vt_bo_customer_street," .
            "b.vt_bo_customer_zipcode," .
            "b.vt_bo_customer_city," .
            "b.vt_bo_customer_country," .
            "b.vt_bo_customer_telephone," .
            "b.vt_bo_customer_mobile," .
            "b.vt_bo_roombookinginfo," .
            "(b.vt_bo_margin_gross - b.vt_bo_servicecharge) as vt_bo_margin_gross," .
            "b.vt_bo_client," .
            "case when b.VT_BO_CLIENT = 'VFLY'
                        then '1'
			else '0'
                END as is_vfly," .
            "b.vt_bo_bookinginformation," .
            "b.vt_bo_cashing," .
            "b.vt_bo_warningflag," .
            "b.vt_bank_transfer," .
            "b.vt_bo_crs," .
            "b.vt_bo_crsagencyno || b.vt_bo_crsdepno as vt_bo_crsagencyno," .
            "to_char(sysdate,'dd.mm.YYYY') as today," .
            "case when ac.LAND is not null then ac.LAND else ac1.LAND end as Land," .
            "b.vt_bo_resortfee," .
            "b.vt_bo_resortfeeorig," .
            "b.vt_bo_resortfeecurrency," .
            "b.vt_entgeltsatz," .
            "b.vt_bo_amt_adults," .
            "b.vt_bo_amt_infants," .
            "b.vt_bo_amt_children," .
            "b.vt_bo_customer_lang," .
            "b.vt_bo_bill_resend_nc," .
            "b.vt_bo_customer_lang," .
            "b.vt_bo_mappedbookingtype," .
            "b.vt_bo_handicapped," .
            "b.vt_bo_pregnant," .
            "b.vt_bo_medicalcareneeded," .
            "b.vt_bo_localtax," .
            "b.vt_bo_localtaxcurrency," .
            "b.vt_bo_hotelprice," .
            "b.vt_ut_ext_id," .
            "(select listagg(trim(substr(fli_flightairline,regexp_instr(fli_flightairline,'[,]') +1)), ';')
                     within group (order by fli_flightseqment_no) as  airlines
                from vt_flights
                where fli_bo_id = b.vt_bo_id
            ) as AirlineInFlights," .
            "(select listagg(trim(substr(fli_flightairline,regexp_instr(fli_flightairline,'[,]') +1)), ';')
                     within group (order by fli_flightseqment_no) as  airlines
                from vt_flights
                where fli_bo_id = b.vt_bo_id
                and substr(fli_flighttype, 0,1) = 'H'
            ) as AirlineInOutboundFlights," .
            "(select listagg(trim(substr(fli_flightairline,regexp_instr(fli_flightairline,'[,]') +1)), ';')
                     within group (order by fli_flightseqment_no) as  airlines
                from vt_flights
                where fli_bo_id = b.vt_bo_id
                and substr(fli_flighttype, 0,1) = 'R'
            ) as AirlineInReturnFlights,
            b.vt_bo_vfly_internal_rula,".
            "b.VT_BO_HANDLING_AGENCY,";
    }

    private function set_vt_hotels()
    {

        $this->vt_hotels = "h.ht_hotelloccode," .
            "h.ht_hotelloccode," .
            "h.ht_hotellocation," .
            "h.ht_hotelcode," .
            "h.ht_hotelname," .
            "h.ht_assingleroom," .
            "case when vt_bo_bookingtype != 'P'
			then (h.ht_end - h.ht_beginn) 
			else (p.vt_pt_end - p.vt_pt_beginn)
		END as ht_duration," .
            "h.ht_roomtypeen," .
            "h.ht_crsaccomodationen," .
            "h.ht_beginn," .
            "h.ht_destairport," .
            "h.HT_TRANSFERAGENT," .
            "h.HT_TRANSFERTYPE," .
            "h.HT_BRANDNAME," .
            "h.HT_TRANSFERCODE," .
            "h.HT_EXTERNALPROZESSNO," .
            "h.HT_TRANSFERAGENTNAME," .
            "h.HT_ROOMCODE," .
            "h.HT_EXTERNALCRS, " .
            "h.HT_INCAGENT," .
            "h.HT_ROOMTYPE," .
            "h.HT_CATEGORY," .
            "h.HT_ROOMDESCRIPTION," .
            "CASE WHEN upper(substr(h.ht_transfercode,-2)) = 'MW'
			THEN '1'
			WHEN  upper(h.ht_hotelname) like '%MIETWAGEN%'
			THEN '1'
                        ELSE '0'
		    END as MWFLAG," .
            "p.vt_pt_beginn," .
            "p.vt_pt_hotellocationcode," .
            "p.vt_pt_destination," .
            "p.vt_pt_hotelname," .
            "p.vt_pt_productcode,";
    }

    private function set_vt_flight_saved()
    {

        $this->vt_flight_saved = "
            case when b.vt_bo_bookingtype = 'P' 
                 then 'NOTIX'
				 else vfs.VT_FLI_SV_TICKETTYPE
			end as VT_FLI_SV_TICKETTYPE," .
            "vfs.vt_fli_sv_departure," .
            "vfs.vt_fli_sv_key," .
            "vfs.vt_fli_sv_destination," .
            "vfs.vt_fli_sv_airline," .
            "vfs.VT_FLI_SV_STORNOFLAG," .
            "vfs.vt_fli_sv_processno," .
            "vfs.vt_fli_sv_provider," .
            "vfs.vt_fli_sv_provider_2," .
            "CASE WHEN b.VT_BO_BOOKINGTYPE != 'P'
			    THEN (select ac2.LC || ',' || ac2.airport from airport_codes ac2 where vfs.vt_fli_sv_departure = ac2.LC and ROWNUM = 1) 
			    ELSE (select ac2.LC || ',' || ac2.airport from airport_codes ac2 where p.vt_pt_departure = ac2.LC and ROWNUM = 1) 
		    END as vt_fli_sv_dep," .
            "CASE WHEN b.VT_BO_BOOKINGTYPE != 'P'
			     THEN (select ac2.LC || ',' || ac2.airport from airport_codes ac2 where vfs.vt_fli_sv_destination = ac2.LC and ROWNUM = 1)
			     ELSE (select ac2.LC || ',' || ac2.airport from airport_codes ac2 where p.vt_pt_destination = ac2.LC and ROWNUM = 1)
		    END as vt_fli_sv_des," .
            "vfft.flighttype," .
            "to_char(vfs.vt_fli_sv_beginn,'dd.mm.YYYY') as vt_fli_sv_beginn," .
            "to_char(vfs.vt_fli_sv_end,'dd.mm.YYYY') as vt_fli_sv_end," .
            "(select DISTINCT(1)
                    from vt_flights f1 
                    where f1.fli_bo_id = b.vt_bo_id  
                    and  SUBSTR(f1.FLI_FLIGHTDESTINATION , 0, REGEXP_INSTR(f1.FLI_FLIGHTDESTINATION,'[,. ]') -1) 
                    IN (SELECT ACA_LC FROM AIRPORT_CODES_AMERIKA 
                    WHERE ACA_LAND in ('USA', 'Kanada', 'DomRep', 'Kuba', 'Mexiko' ))) as is_Amerika,";
    }

    private function set_vt_reclamation_coupon()
    {

        $this->vt_reclamation_coupon = "vrcp.vrcp_id," .
            "vrcp.vrcp_hash," .
            "vrcp.vrcp_exported," .
            "vrcp.vrcp_no," .
            "vrcp.vrcp_amount," .
            "vrcp.vrcp_send_via_mail,";
    }

    private function set_vt_reclamation()
    {

        $this->vt_reclamation = "vtr.vtr_email_send," .
            "vtr.vtr_state," .
            "vtr.vtr_email," .
            "vtr.vtr_confirm," .
            "vtr.vtr_insert_by_name," .
            "vtr.vtr_insert_by_fname," .
            "to_char(vtr.vtr_eingang_date,'dd.mm.YYYY') as vtr_eingang_date,";
    }

    private function set_vt_reclamation_refund()
    {

        $this->vt_reclamation_refund = "vrr.vrr_recipient_fname," .
            "vrr.vrr_recipient_name,";
    }

    private function set_vt_bookings_parameter()
    {

        $this->vt_bookings_parameter = "vbp.vbp_prepayment_mail," .
            "vbp.vbp_zahlschein_az," .
            "vbp.vbp_zahlschein_rz," .
            "vbp.vbp_vfly_customer," .
            "vbp.vbp_inform_flight_time_change," .
            "vbp.vbp_inform_flight_time_ch_date,";
    }

    private function set_vt_cc_guwid()
    {

        $this->vt_cc_guwid = "vcc.cc_amount," .
            "vcc.cc_booking_type," .
            "vcc.cc_process," .
            "vcc.info_mail_send,";
    }

    private function set_vt_history()
    {

        $this->vt_history = "to_char(vh.HST_INSERT_TIMESTAMP,'dd.mm.YYYY') as HST_INSERTTIMESTAMP,";
    }

    private function set_vt_rulas_send()
    {
        $this->vt_rulas_send = "to_char(ru_send_time,'YYYY-MM-DD') as ru_send_time,";
    }

    private function set_vt_eft_invalid()
    {

        $this->vt_eft_invalid = "to_char(vei.created,'YYYY-MM-DD') as created," .
            "vei.mail_send,";
    }

    private function set_vt_flights_first()
    {

        $this->vt_flights_first = "TRIM(SUBSTR(FLI_FLIGHTAIRLINE,INSTR(FLI_FLIGHTAIRLINE,',')+1)),";
    }

    private function set_vt_dunnings()
    {
        $this->vt_dunnings = " DUN_ID,";
    }

    private function set_vt_bookings_checkin()
    {
        $this->vt_bookings_checkin = " vbc_chkin_beginn_from,"
            . " vbc_chkin_beginn_to,"
            . " vbc_chkin_end_from,"
            . " vbc_chkin_end_to,"
            . " vbc_chkin_mail_beginn_send, "
            . " vbc_chkin_mail_end_send,";

    }

    private function set_boni_data()
    {

        $this->boni_data = "
                 score_ampel_id,
                 score_wert,
                 score_ampel_value,
                 vt_edit,
                 vt_vmix_txt,
                 to_char(vt_edit_date,'YYYY-MM-DD') as vt_edit_date,
                 boniver_checked,
                 to_char(boniver_checkdate,'YYYY-MM-DD') as boniver_checkdate,";
    }

    private function set_zahlungsimport()
    {
        $this->zahlungs_import = "
            zi_mailsend,
            betrag,
            inserttime,";
    }

    private function set_exchange_rates()
    {
        $this->exchange_rates_list = "
            er_exchangecurrencycode, 
            er_conversionrate,";
    }

    /**
     * @return string
     */
    public function get_exchange_rates()
    {
        return $this->exchange_rates_list;
    }
}
