<?php

namespace Vtours\Rula2Engine;

/**
 * *
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 *
 */


class Rula2DocucenterFile
{

    private $root;
    public $zielGebiet;
    public $hotelCode;
    public $hotelLocationCode;
    public $vt_bo_id;
    public $vt_bo_beginnYear;
    public $vt_fli_sv_tickettype;
    public $vt_bo_bookingtype;
    private $dirHandle;
    private $files = array();
    private $filesTr = array();
    private $filesFlug = array();
    private $filesZg = array();
    private $client;
    public $ht_transferagent;
    public $incAgency;
    public $tempZg;
    public $mode;
    public $ausnahmen_X;
    public $ausnahmen_E;

    public function __construct()
    {

        $this->root = \Config::stepIn()->cfg('RULA_PARTITION');
        $this->client = \Config::stepIn()->cfg('PAGE_NAME');
    }

    public function uplaodFile()
    {


        $for = \Context::stepIn()->getVar('for');

        if ($for == 'Flug') {

            $destination = $this->getDirectoryForFlight();
        }

        if ($for == 'zg') {

            $destination = $this->getDirectoryForZielGebiet();
        }

        if ($for == 'hlc') {

            $destination = $this->getDirectoryForHotelLocation();
        }
        if ($for == 'hc') {

            $destination = $this->getDirectoryForHotelCode();
        }
        if ($for == 'vgnr') {

            $destination = $this->getBookingsDirectory();
        }

        if ($for == 'incAg') {

            $destination = $this->getIncomingDir(\Context::stepIn()->getVar('incAg'));
        }
        if ($destination != '' && isset($destination)) {

            $this->dirExistsCreateDir($destination);
            $tmp = $_FILES['uploadFile']['name'];
            $filename = str_replace(array('#', 'ä', 'Ä', 'ü', 'Ü', 'ö', 'Ö', ' '),
                array('', 'ae', 'Ae', 'ue', 'Ue', 'oe', 'Oe', ''), $tmp);
            $stat = file_put_contents($destination . "/" . $filename,
                file_get_contents($_FILES['uploadFile']['tmp_name']));
            return true;
        } else {
            return false;
        }
    }

    public function getDirectoryForFlight($stat = '')
    {

        $destination = $this->root . "/" .
            $this->zielGebiet . "/" .
            $this->hotelLocationCode . "/" .
            $this->hotelCode . "/" .
            $this->vt_bo_beginnYear . "/" .
            $this->vt_bo_id .
            \Config::stepIn()->cfg('RULA_FLUGDIR');
        if ($stat == 'file') {
            $destination .= "/" . $_FILES['uploadFile']['name'];
        }

        return $destination;
    }

    public function getDirectoryForZielGebiet()
    {


        if (is_array($res = $this->getDataFromSpzFoldersInDb())) {

            $destination = $this->root . "/" . $res['ORDNER_NAME'];
            $this->mode = "speziell";
            $this->tempZg = $res['ORDNER_NAME'];

            return $destination;
        } else {
            $this->tempZg = "";
            $destination = $this->root . "/" . $this->zielGebiet;

            return $destination;
        }
    }

    public function getDirectoryForHotelLocation()
    {
        if ($this->vt_bo_bookingtype != 'F') {
            $destination = $this->root . "/" .
                $this->zielGebiet . "/" .
                $this->hotelLocationCode;
        } elseif ($this->vt_bo_bookingtype == 'F') {
            $destination = $this->root . "/" .
                $this->zielGebiet . "/" .
                'nurFlug';
        }
        return $destination;
    }

    public function getDirectoryForHotelCode()
    {
        if ($this->vt_bo_bookingtype != 'F') {
            $destination = $this->root . "/" .
                $this->zielGebiet . "/" .
                $this->hotelLocationCode . "/" .
                $this->hotelCode;
        } elseif ($this->vt_bo_bookingtype == 'F') {
            $destination = $this->root . "/" .
                $this->zielGebiet . "/" .
                'nurFlug/nurFlug';
        }
        return $destination;
    }

    public function getBookingsDirectory()
    {

        if ($this->vt_bo_bookingtype != 'F') {
            $destination = $this->root . "/" .
                $this->zielGebiet . "/" .
                $this->hotelLocationCode . "/" .
                $this->hotelCode . "/" .
                $this->vt_bo_beginnYear . "/" .
                $this->vt_bo_id;
        } else {
            $destination = $this->root . "/" .
                $this->zielGebiet . "/" .
                'nurFlug/' .
                'nurFlug/' .
                $this->vt_bo_beginnYear . "/" .
                $this->vt_bo_id;
        }
        return $destination;
    }

    public function getAllFilesForBooking()
    {

        if ($this->dirExistsCreateDir($this->getDirectoryForZielGebiet())) {
            $stat = $this->openDir($this->getDirectoryForZielGebiet());
        }

        if ($this->dirExistsCreateDir($this->getDirectoryForHotelLocation())) {
            $stat = $this->openDir($this->getDirectoryForHotelLocation());
        }

        if ($this->dirExistsCreateDir($this->getDirectoryForHotelCode())) {
            $stat = $this->openDir($this->getDirectoryForHotelCode());
        }

        if ($this->dirExistsCreateDir($this->getBookingsDirectory())) {
            $stat = $this->openDir($this->getBookingsDirectory());
        }

        if (!$stat) {
            $this->files['error'] = true;
        }

        $this->unsetStandartDocuments();

        return $this->files;
    }

    public function unsetStandartDocuments()
    {

        $ausnahmen = explode(',', \Config::stepIn()->cfg('RULA_STD_NAME'));

        foreach ($ausnahmen as $pattern) {
            $pattern = '/^' . $pattern . '/';
            foreach ($this->files as $key => $value) {
                preg_match($pattern, $key, $treffer);
                if (count($treffer) > 0) {
                    unset($this->files[$key]);
                }
            }
        }
    }

    public function openDir($dir, $typ = "")
    {
        #print_r($this->filesZg);
        $this->dirHandle = opendir($dir);

        if ($this->dirHandle) {
            while (($file = readdir($this->dirHandle)) != false) {
                #print_r($file);
                if ($file != '.' && $file != '..' && filetype($dir . "/" . $file) == 'file' && substr(strtolower($file),
                        -4) == '.pdf'
                ) {
                    if ($typ == 'FLUG') {
                        $this->filesFlug[$file]['dir'] = $dir . "/" . $file;
                        $this->filesFlug[$file]['type'] = 'FLUG';
                    }
                    if ($typ == 'ZGA' || $typ == '') {
                        if (substr($file, 0, strpos($file, '_') + 1) == 'Anschreiben_') {

                            $this->filesZg[strtolower($file)]['dir'] = $dir . "/" . $file;
                            $this->filesZg[strtolower($file)]['type'] = 'ZGA';
                            #print_r($this->filesZg);
                        }
                    } else {

                        if (substr(strtolower($file), 0, strpos($file, '_') + 1) == 'transfervoucher_') {

                            $this->filesTr['dir'] = $dir . "/" . $file;
                            $this->filesTr['name'] = $file;
                            $this->filesTr['type'] = 'TRA';
                            $this->filesTr['dispName'] = substr($file, 0, 30);
                        } else {
                            $this->files[$file]['dir'] = $dir . "/" . $file;
                            $this->files[$file]['type'] = 'SPZ';
                            $this->files[$file]['dispName'] = substr($file, 0, 30);
                        }
                    }
                }
            }
            return true;
        } else {
            return false;
        }
    }

    public function getContentFromFileSystem($dir)
    {

        $data = file_get_contents($dir);
        return $data;
    }

    public function getFlugBerechtigungsScheine()
    {
        $data = array();
        $t = 0;

        foreach ($this->filesFlug as $key => $value) {
            $data[$t]['name'] = $key;
            $data[$t]['dir'] = $value['dir'];
            $data[$t]['type'] = $value['type'];
            $data[$t]['dispName'] = substr($key, 0, 30);
            $t++;
        }


        return $data;
    }

    public function getZgAnschreiben()
    {

        if ($this->client == 'xits') {

            if (count($this->filesZg) > 1) {
                $key = $this->getWrightZielgebietsAnschreibenFromArray();
            } else {
                $key = key($this->filesZg);
            }
        } elseif ($this->client == 'vtours.de') {

            if (count($this->filesZg) >= 1) {
                $key = $this->getWrightZielgebietsAnschreibenFromArrayVto();
            }
        } elseif ($this->client != xits && $this->client != 'vtours.de') {
            $key = key($this->filesZg);
        }
        #print_r($this->filesZg);
        # echo $key;
        $data['name'] = $key;
        $data['dispName'] = substr($key, 0, 30);
        $data['type'] = $this->filesZg[strtolower($key)]['type'];
        $data['dir'] = $this->filesZg[strtolower($key)]['dir'];

        # print_r($data);
        return $data;
    }

    public function deleteFromFileSystem()
    {

        global $rs;

        $link = \Config::stepIn()->cfg('URL') . substr($_SERVER['PHP_SELF'], 1)
            . "?cmd=" . \Context::stepIn()->getVar('cmd')
            . "&a=show&zg=$this->zielGebiet&hlc=$this->hotelLocationCode&hc=$this->hotelCode"
            . "&sh=" . $this->vt_bo_id;
        if (\Context::stepIn()->getVar('spz') == 1) {

            if (file_exists($this->files[\Context::stepIn()->getVar('content')]['dir'])) {
                $stat = unlink($this->files[\Context::stepIn()->getVar('content')]['dir']);
            }
            if (!$stat) {
                return false;
            } else {

                header("LOCATION:" . $link);
            }
        }
        if (\Context::stepIn()->getVar('flug') == 1) {
            if (file_exists($this->filesFlug[\Context::stepIn()->getVar('content')]['dir'])) {
                $stat = unlink($this->filesFlug[\Context::stepIn()->getVar('content')]['dir']);
                #header('LOCATION:'.$link );
            }
            if (!$stat) {
                return false;
            } else {
                header("LOCATION:" . $link);
            }
        }
    }

    public function dirExistsCreateDir($dir)
    {

        if (is_dir($dir)) {

            return true;
        } else {
            if (mkdir($dir, 0777, true)) {

                return true;
            } else {

                return false;
            }
        }
    }

    private function getWrightZielgebietsAnschreibenFromArray()
    {

        foreach ($this->filesZg as $key => $value) {

            if ($this->ht_transferagent != '') {

                if ($key == strtolower(\Config::stepIn()->cfg('RULA_ZGA_NAME') . $this->zielGebiet . "_" . $this->ht_transferagent . ".pdf")) {
                    return $key;
                }
            } else {
                if ($this->ht_transferagent == '') {

                    if ($key == strtolower(\Config::stepIn()->cfg('RULA_ZGA_NAME') . $this->zielGebiet . "_OT.pdf")) {
                        return $key;
                    }
                } else {

                    if ($key == strtolower(\Config::stepIn()->cfg('RULA_ZGA_NAME') . $this->zielGebiet . ".pdf")) {
                        return $key;
                    }
                }
            }
        }
    }

    public function getWrightZielgebietsAnschreibenFromArrayVto()
    {

        $zielGebiet = $this->zielGebiet;
        if ($this->tempZg != '') {
            $zielGebiet = $this->tempZg;
        }

        if ($this->noAnschreibenVto($this->incAgency, $this->vt_bo_bookingtype)) {
            return;
        }

        if ($this->incAgency && $this->vt_bo_bookingtype != 'F') {
            if (!$this->ht_transferagent || in_array($this->vt_bo_bookingtype, array('E', 'B'))) {
                if ($this->filesZg[strtolower(\Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . "_" . $this->incAgency . "_Erde.pdf")]['type'] == 'ZGA'
                    && in_array($this->vt_bo_bookingtype, array('E', 'B'))
                ) {
                    return \Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . "_" . $this->incAgency . "_Erde.pdf";
                }
                if ($this->filesZg[strtolower(\Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . "_" . $this->incAgency . "_OT.pdf")]['type'] == 'ZGA') {

                    return \Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . "_" . $this->incAgency . "_OT.pdf";
                }
                if ($this->filesZg[strtolower(\Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . "_ERDE.pdf")]['type'] == 'ZGA'
                    && in_array($this->vt_bo_bookingtype, array('E', 'B'))
                ) {

                    return \Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . "_ERDE.pdf";
                }
                if ($this->filesZg[strtolower(\Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . "_OT.pdf")]['type'] == 'ZGA') {

                    return \Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . "_OT.pdf";
                }
                if ($this->filesZg[strtolower(\Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . ".pdf")]['type'] == 'ZGA'
                    && !in_array($this->vt_bo_bookingtype, array('E', 'B'))
                ) {

                    return \Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . ".pdf";
                }
            } elseif (!in_array($this->vt_bo_bookingtype, array('E', 'B')) || $this->vt_bo_bookingtype != 'F') {
                if ($this->filesZg[strtolower(\Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . "_" . $this->incAgency . ".pdf")]['type'] == 'ZGA') {

                    return \Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . "_" . $this->incAgency . ".pdf";
                }
                if ($this->filesZg[strtolower(\Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . ".pdf")]['type'] == 'ZGA') {

                    return \Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . ".pdf";
                }
            } else {
                if ($this->filesZg[strtolower(\Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . ".pdf")]['type'] == 'ZGA') {

                    return \Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . ".pdf";
                }
            }
        } else {
            if ($this->filesZg[strtolower(\Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . ".pdf")]['type'] == 'ZGA') {

                return \Config::stepIn()->cfg('RULA_ZGA_NAME') . $zielGebiet . ".pdf";
            }
        }
    }

    private function getIncomingDir($incAgency)
    {

        $stmt = " SELECT ID,ORDNER_NAME,TYPE
                  FROM RULA_ZG_SPZ_ORDNER
                  WHERE TYPE = 'INCAGENT'
                  AND ORDNER_NAME = '" . $incAgency . "'";

        $res = \DB::stepIn()->getAll($stmt);

        return $this->root . "/" . $res[0]['ORDNER_NAME'];
    }

    private function getDataFromSpzFoldersInDb()
    {

        if (\Config::stepIn()->cfg('PAGE_NAME') == 'vtours.de') {
            if ($this->vt_bo_id != '') {
                $stmt = "SELECT ID,ORDNER_NAME,TYPE
                         FROM VT_HOTELS,RULA_ZG_BELONG,RULA_ZG_SPZ_ORDNER
                         WHERE HT_BO_ID = $this->vt_bo_id
                         AND CODE = '$this->incAgency'
                         AND TYPE = 'INCAGENT'
                         AND ORDNER_ID = ID";
                $res = \DB::stepIn()->getAll($stmt);
            } else {
                $stmt = "SELECT ID,ORDNER_NAME,TYPE
                         FROM RULA_ZG_BELONG,RULA_ZG_SPZ_ORDNER
                         WHERE CODE = '" . \Context::stepIn()->getVar('zg') . "'
                         AND TYPE = 'ORDNER'";
                $res = \DB::stepIn()->getAll($stmt);
            }
            if (count($res) > 0) {

                return $res[0];
            } else {

                $stmt = "SELECT ORDNER_ID FROM RULA_ZG_BELONG WHERE CODE = '$this->zielGebiet'";

                $id = \DB::stepIn()->getOne($stmt);

                if ($id > 0) {

                    $stmt = "SELECT * FROM RULA_ZG_SPZ_ORDNER WHERE ID = '$id'";

                    $res = \DB::stepIn()->getAll($stmt);

                    return $res[0];
                } else {
                    return 0;
                }
            }
        }
    }

    public function getTransferFiles()
    {
        if (in_array($this->vt_bo_bookingtype, array('E', 'B')) && $this->vt_bo_bookingtype != 'F') {
            return $this->filesTr;
        }
    }

    public function noAnschreibenVto($incAgency, $bookingtype)
    {


        if (in_array(strtoupper($bookingtype), array('E', 'B'))) {

            $temp = \Config::stepIn()->cfg('RULA_NO_ANSCHREIBEN_INC_E');
            $ausnahmen = explode(',', $temp);
        }

        if (in_array(strtoupper($bookingtype), array('X', 'C', 'B'))) {

            $temp = \Config::stepIn()->cfg('RULA_NO_ANSCHREIBEN_INC_X');
            $ausnahmen = explode(',', $temp);
        }

        foreach ($ausnahmen as $value) {
            if (strtoupper($value) == $incAgency) {
                return true;
            } else {
                continue;
            }
        }
        return false;
    }

}
