<?php

namespace TraveltainmentApi\Action;

use Pimcore\Model\Element\ValidationException;
use Pimcore\Model\Object\VtoursDatenAngebot;
use TraveltainmentApi\Model\DatenAngebotModel;
use TraveltainmentApi\WebService\TraveltainmentService;

/**
 * Class Update
 *
 * @package TraveltainmentApi\Action
 */
class Update
{
    /**
     * @var TraveltainmentService
     */
    private $traveltainmentService;
    private $datenAngebotModel;

    /**
     * Update constructor.
     */
    public function __construct()
    {
        $this->traveltainmentService = new TraveltainmentService();
        $this->datenAngebotModel = new DatenAngebotModel();
    }

    /**
     * @param VtoursDatenAngebot $object
     *
     * @throws ValidationException
     */
    public function updateObject(VtoursDatenAngebot $object)
    {

        $hotelCode = $object->getHotelCode();

        $travelPeriodStart = $object->getTravelPeriodStart();
        $travelPeriodEnd = $object->getTravelPeriodEnd();

        $travelDurationMin = $object->getTravelDurationMin();
        $travelDurationMax = $object->getTravelDurationMax();

        $mealType = $object->getMealType();
        $offerType = $object->getOfferType();

        if ($hotelCode != null && $offerType != null) {
            $offerData = $this->traveltainmentService->getOfferByHotelCode(
                [$travelDurationMin, $travelDurationMax],
                [$travelPeriodStart, $travelPeriodEnd],
                $mealType,
                $hotelCode,
                $offerType
            );

            if (empty($offerData)) {
                throw new ValidationException('Offer could not be found.', 400);
            }

            $this->datenAngebotModel->mapObject($object, $offerData);
        }
    }
}
