<?php

namespace TraveltainmentApi;

use Doctrine\Common\Annotations\AnnotationRegistry;
use Pimcore\API\Plugin as PluginLib;
use Pimcore\Log\ApplicationLogger;
use Pimcore\Model\Object\VtoursDatenAngebot;
use Symfony\Component\VarDumper\Cloner\VarCloner;
use Symfony\Component\VarDumper\Dumper\CliDumper;
use Symfony\Component\VarDumper\VarDumper;
use TraveltainmentApi\Action\Update;

/**
 * Class Plugin
 *
 * @package TraveltainmentApi
 */
class Plugin extends PluginLib\AbstractPlugin implements PluginLib\PluginInterface
{
    /**
     * init
     */
    public function init()
    {
        parent::init();

        AnnotationRegistry::registerLoader('class_exists');

        $logger = ApplicationLogger::getInstance('TraveltainmentApi', true);
        $this->initDump($logger);

        \Pimcore::getEventManager()->attach(['object.preUpdate'], function (\Zend_EventManager_Event $event) {
            $object = $event->getTarget();

            if ($object instanceof VtoursDatenAngebot) {
                $update = new Update();
                $update->updateObject($object);
            }
        });
    }

    /**
     * initDump
     *
     * @param ApplicationLogger $logger
     */
    private function initDump(ApplicationLogger $logger)
    {

        VarDumper::setHandler(function ($var) use ($logger) {

            $cloner = new VarCloner();
            $dumper = new CliDumper();
            $output = fopen('php://memory', 'r+b');

            $dumper->dump($cloner->cloneVar($var), $output);
            $logger->debug(stream_get_contents($output, -1, 0));
        });
    }

    /**
     * install
     *
     * @return bool
     */
    public static function install()
    {
        // implement your own logic here
        return true;
    }

    /**
     * uninstall
     *
     * @return bool
     */
    public static function uninstall()
    {
        // implement your own logic here
        return true;
    }

    /**
     * isInstalled
     *
     * @return bool
     */
    public static function isInstalled()
    {
        // implement your own logic here
        return true;
    }
}
