<?php

namespace TraveltainmentApi\WebService;

use Vtours\TTXmlWebService\Model\Response\Hotel;
use Vtours\TTXmlWebService\Model\Response\Meal;
use Vtours\TTXmlWebService\Model\Response\Offer;
use Vtours\TTXmlWebService\Model\Response\Region;
use Vtours\TTXmlWebService\Model\Response\WeatherResponse\YearOverview;

class TraveltainmentService
{

    /**
     * @var \Vtours\TTXmlWebService\Service\TravelTainmentService
     */
    private $traveltainmentService;

    public function __construct()
    {
        $this->traveltainmentService = new \Vtours\TTXmlWebService\Service\TravelTainmentService();
    }

    public function getOfferByHotelCode(array $travelDuration, array $travelPeriod, $mealType, $hotelCode, $offerType)
    {
        /**
         * @var $searchEngineOfferListResponse \Vtours\TTXmlWebService\Model\Response\SearchEngineOfferListRS
         */
        $searchEngineOfferListResponse = $this->traveltainmentService->getAllHotelOffersByGiata($travelDuration, $travelPeriod, $mealType,
            $hotelCode, $offerType);

        if ($searchEngineOfferListResponse->getInfoMessage() == null) {

            if ($searchEngineOfferListResponse->getResultSet()->getTotalNumberOfResults() != 0 && $searchEngineOfferListResponse->isSuccess()) {
                $objectData = $this->createObjectData($searchEngineOfferListResponse->getResultSet()->getListItem()[0]->getOffer(),
                    $searchEngineOfferListResponse->getHotel(), $searchEngineOfferListResponse->getRegion(), $offerType);

                return $objectData;
            }
        } else {
            //infomessage is only set, if tt returns an error
            //maybe add info for pimcore-user
            return [];
        }
    }


    public function createObjectData(Offer $offer, Hotel $hotel, Region $region, $offerType)
    {
        $objectData = [];
        $objectData['hotel'] = $this->getHotelData($hotel, $objectData);
        $objectData['region'] = $this->getRegionData($region, $objectData);
        $objectData['offer'] = $this->getOfferData($offer, $objectData, $offerType);

        return $objectData;
    }

    public function getHotelData(Hotel $hotel, array $objectData)
    {
        if ($hotel != null) {
            $objectData = [
                'hotelName'    => $hotel->getObjectName(),
                'hotelCity'    => $hotel->getCity()->getCity(),
                'hotelStars'   => $hotel->getCategory()->getStars(),
                'hotelPicture' => $hotel->getObjectImages()->getLargeImage()
            ];
        }

        return $objectData;
    }

    public function getRegionData(Region $region, $objectData)
    {
        /** @var $clima YearOverview */
        $regionClima = 'undefined';
        foreach ($region->getWeatherForRegion()->getClimaData()->getYearOverview() as $clima) {
            if ($clima->getClimaDataType() == 'MaxTemperature') {
                $regionClima = $clima->getValueOfMonth()->getValueOfMonth();
            }
        }

        if ($region != null) {
            $objectData = [
                'hotelCountry' => $region->getCountry(),
                'regionClima'  => $regionClima
            ];
        }

        return $objectData;
    }

    public function getOfferData(Offer $offer, $objectData, $offerType)
    {
        if ($offer != null) {
            $objectData = [
                'offerID'             => $offer->getOfferId(),
                'offerMinPrice'       => $offer->getPriceInformation()->getOriginalPrice()->getOriginalPrice(),
                'offerPriceCurrency'  => $offer->getPriceInformation()->getOriginalPrice()->getCurrency(),
                'offerWithFlight'     => false,
                'offerWithTransfer'   => false,
                'offerTravelDuration' => $offer->getTravelDuration()
            ];
            if ($offerType == 'Hotel') {
                /** @var Meal $meal */
                $meal = $offer->getAccommodation()->getMeal();
                $objectData['offerMealType'] = $meal->getMeal();
                $objectData['offerRoomType'] = $offer->getAccommodation()->getRoom()->getRoom();
            } else {
                if ($offerType == 'Package') {
                    $objectData['offerWithFlight'] = true;
                    $objectData['offerMealType'] = $offer->getPackage()->getAccommodation()->getMeal()->getMeal();
                    $objectData['offerRoomType'] = $offer->getPackage()->getAccommodation()->getRoom()->getRoom();

                    $journeyAttributes = $offer->getSpecialJourneyAttributes();
                    if ($journeyAttributes != null && (strpos($journeyAttributes, 'TRANSFER')) !== false) {
                        $objectData['offerWithTransfer'] = true;
                    }
                }
            }
        }

        return $objectData;
    }
}
