<?php

namespace TraveltainmentApi\Action;

use Pimcore\Model\Element\ValidationException;
use Pimcore\Model\Object\VtoursDatenAngebot;
use TraveltainmentApi\Model\DatenAngebotModel;
use TraveltainmentApi\WebService\TraveltainmentApiService;

/**
 * Class UpdateOffer
 *
 * @package TraveltainmentApi\Action
 */
class UpdateOffer
{
    /**
     * @var TraveltainmentApiService
     */
    private $traveltainmentApiService;
    private $datenAngebotModel;

    /**
     * Update constructor.
     */
    public function __construct()
    {
        $this->traveltainmentApiService = new TraveltainmentApiService();
        $this->datenAngebotModel = new DatenAngebotModel();
    }

    /**
     * @param VtoursDatenAngebot $object
     *
     * @throws ValidationException
     */
    public function updateObject(VtoursDatenAngebot $object)
    {
        $code = $object->getCode();
        $codeType = $object->getCodeType();

        $travelPeriodStart = $object->getTravelPeriodStart();
        $travelPeriodEnd = $object->getTravelPeriodEnd();

        $traveller = $object->getTraveller();

        $travelDurationMin = $object->getTravelDurationMin();
        $travelDurationMax = $object->getTravelDurationMax();

        $mealType = $object->getMealType();
        $offerType = $object->getOfferType();

        if ($codeType != 'TopRegionID') {

            $offerData = $this->traveltainmentApiService->getOfferByHotelCode(
                [$travelDurationMin, $travelDurationMax],
                [$travelPeriodStart, $travelPeriodEnd],
                $mealType,
                $traveller,
                $code,
                $codeType,
                $offerType);
        } else {
            $offerData = $this->traveltainmentApiService->getOfferByRegionCode(
                [$travelDurationMin, $travelDurationMax],
                [$travelPeriodStart, $travelPeriodEnd],
                $mealType,
                $traveller,
                $code,
                $offerType
            );
        }

        if ($offerData != []) {
            $this->datenAngebotModel->mapObject($object, $offerData);

        } else {
            throw new ValidationException('no offers available for this request data', 400);
        }
    }
}
