<?php

namespace TraveltainmentApi\Action;

use Pimcore\API\Plugin\Exception;
use Pimcore\Model\Element\ValidationException;
use Pimcore\Model\Object\VtoursDatenAngebot;
use TraveltainmentApi\Model\DatenAngebotModel;
use TraveltainmentApi\WebService\TraveltainmentApiService;

/**
 * Class UpdateOffer
 *
 * @package TraveltainmentApi\Action
 */
class UpdateOffer
{
    /**
     * @var TraveltainmentApiService
     */
    private $traveltainmentApiService;
    private $datenAngebotModel;

    /**
     * Update constructor.
     */
    public function __construct()
    {
        $this->traveltainmentApiService = new TraveltainmentApiService();
        $this->datenAngebotModel = new DatenAngebotModel();
    }

    /**
     * @param VtoursDatenAngebot $object
     *
     * @throws ValidationException
     */
    public function updateObject(VtoursDatenAngebot $object)
    {
        $code = $object->getCode();
        $codeType = $object->getCodeType();

        $travelPeriodStart = $object->getTravelPeriodStart();
        $travelPeriodEnd = $object->getTravelPeriodEnd();

        $travellers = [];
        if ($object->getTravellers() != 0 || $object->getTravellers() != null) {
            foreach ($object->getTravellers() as $traveller) {
                $travellers[] = $traveller['age']->getData();
            }
        }
        if (empty($travellers)) {
            throw new ValidationException('missing mandytory field \'Reisende\'', 400);
        }

        $priceMin = $object->getPriceMin();
        if ($priceMin != null) {
            $priceMin = $priceMin->getValue();
        }
        $priceMax = $object->getPriceMax();
        if ($priceMax != null) {
            $priceMax = $priceMax->getValue();
        }

        $brand = $object->getBrand();


        $hotelAttributes['SANDYBEACH'] = $object->getIncludeSandybeach();
        $hotelAttributes['ADULTSONLY'] = $object->getIncludeAdultsonly();
        $hotelAttributes['FAMILYFRIENDLY'] = $object->getIncludeFamilyfriendly();

        $specialJourneyAttributes['TRANSFER'] = $object->getIncludeTransfer();

        $travelDurationMin = $object->getTravelDurationMin();
        $travelDurationMax = $object->getTravelDurationMax();

        $mealType = $object->getMealType();
        $departureAirport = $object->getDepartureAirportSelect();
        $offerType = $object->getOfferType();
        try {
            if ($codeType != 'TopRegionID') {
                $offerData = $this->traveltainmentApiService->getOfferByHotelCode(
                    [$travelDurationMin, $travelDurationMax],
                    [$travelPeriodStart, $travelPeriodEnd],
                    $mealType,
                    $travellers,
                    [$priceMin, $priceMax],
                    $hotelAttributes,
                    $specialJourneyAttributes,
                    $brand,
                    $departureAirport,
                    $code,
                    $codeType,
                    $offerType);
            } else {
                $offerData = $this->traveltainmentApiService->getOfferByRegionCode(
                    [$travelDurationMin, $travelDurationMax],
                    [$travelPeriodStart, $travelPeriodEnd],
                    $mealType,
                    $travellers,
                    [$priceMin, $priceMax],
                    $hotelAttributes,
                    $specialJourneyAttributes,
                    $brand,
                    $departureAirport,
                    $code,
                    $offerType
                );
            }
            if ($offerData != []) {
                $this->datenAngebotModel->mapObject($object, $offerData);

            } else {
                throw new ValidationException('no offers available for this request data', 400);
            }
        } catch (Exception $e) {
            throw new ValidationException($e->getMessage(), 400);
        }

    }
}
