<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace TraveltainmentApi\Helper;


use Pimcore\Model\Object\Folder as PimcoreFolder;
use TraveltainmentApi\Exception\FolderNotFoundException;

/**
 * Class Folder
 *
 * @package TraveltainmentApi\Helper
 */
class Folder
{

    /**
     * region tree path
     */
    const PATH = '/vtours/daten/regionen-iff-codes/';

    /**
     * getFolder
     *
     * @return \Pimcore\Model\Object\AbstractObject
     * @throws FolderNotFoundException
     */
    public function getFolder()
    {

        $folder = PimcoreFolder::getByPath(static::PATH);

        if ($folder == null) {
            throw new FolderNotFoundException('path "' . static::PATH . '" not found');
        }

        return $folder;
    }
}