<?php

namespace TraveltainmentApi\Model;

use Pimcore\File;
use Pimcore\Model\Asset;
use Pimcore\Model\Object\Data\QuantityValue;
use Pimcore\Model\Object\QuantityValue\Unit;
use Pimcore\Model\Object\VtoursDatenAngebot;

/**
 * Class DatenAngebotModel
 *
 * @package TraveltainmentApi\Model
 */
class DatenAngebotModel
{

    /**
     * mapObject
     *
     * @param VtoursDatenAngebot $object
     * @param array              $offerData
     *
     * @return VtoursDatenAngebot
     */
    public function mapObject(VtoursDatenAngebot $object, array $offerData)
    {
        $object->setHotelName((string)$offerData['hotel']['hotelName']);
        $object->setLocation($offerData['hotel']['hotelCity']);
        $object->setCountry($offerData['region']['hotelCountry']);
        $object->setCategory($offerData['hotel']['hotelStars']);
        $object->setLocationID($offerData['region']['destinationId']);

        $this->mapImage($object, $offerData['hotel']['hotelPicture']);

        $object->setMaxTemperature($offerData['region']['regionClima']);

        $price = ($offerData['offer']['offerMinPrice']);

        $unit = Unit::getByAbbreviation($offerData['offer']['offerPriceCurrency']);

        $priceObject = new QuantityValue($price);
        if ($unit != null && $unit->getId() != null) {
            $priceObject = new QuantityValue($price, $unit->getId());
        }

        $object->setPrice($priceObject);

        $object->setOfferId($offerData['offer']['offerID']);

        $object->setMeal($offerData['offer']['offerMealType']);
        $object->setDuration($offerData['offer']['offerTravelDuration']);
        $object->setRoomType($offerData['offer']['offerRoomType']);

        $object->setFlight($offerData['offer']['offerWithFlight']);
        $object->setTransfer($offerData['offer']['offerWithTransfer']);
        if ($offerData['offer']['offerDepartureAirport']) {
            $object->setDepartureAirport($offerData['offer']['offerDepartureAirport']->getIataCode());
        }

        $deeplinkObject = new \Pimcore\Model\Object\Data\Link();
        $deeplink = $offerData['deeplink']['deeplink'];
        $deeplinkParameters = $offerData['deeplink']['parameters'];
        $deeplinkPrefix = $offerData['deeplink']['prefix'];
        $deeplinkObject->setParameters($deeplinkParameters);
        $deeplinkObject->setPath(substr($deeplinkPrefix, 0, strlen($deeplinkPrefix) - 1));
        $deeplinkObject->setText($deeplink);

        $object->setDeepLink($deeplinkObject);

        return $object;
    }

    /**
     * mapImage
     *
     * @param VtoursDatenAngebot $object
     * @param                    $imagePath
     */
    public function mapImage(VtoursDatenAngebot $object, $imagePath)
    {

        $fileName = (File::getValidFilename(substr($imagePath, strrpos($imagePath, '/') + 1)));

        $asset = Asset::getByPath("/vtours.de/daten/angebote/" . $fileName);
        if ($asset == null) {
            $newAsset = new Asset();
            $newAsset->setFilename($fileName);
            $newAsset->setData(file_get_contents($imagePath));
            $newAsset->setParent(Asset::getByPath("/vtours.de/daten/angebote/"));
            $newAsset->save();
        } else {
            $asset->setData(file_get_contents($imagePath));
            $asset->save();
        }

        /**
         * yes we need to get it again
         */
        $asset = Asset::getByPath('/vtours.de/daten/angebote/' . $fileName);
        $object->setHotelPicture($asset);
    }
}
