<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */


namespace TraveltainmentApi\Command;

use Pimcore\Console\AbstractCommand;
use Pimcore\Model\Element\ValidationException;
use Pimcore\Model\Object\VtoursDatenAngebot;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use TraveltainmentApi\Action\UpdateOffer;
use Vtours\TTXmlWebService\DependencyInjection\StartupContainerBuilder\StartupContainerBuilder;

class DatenAngebotCommandV2 extends AbstractCommand
{
    /**
     * configure
     */
    protected function configure()
    {
        $this
            ->setName('vtours:tt:angebot')
            ->setDescription('refreshes all published offers from tt');
    }

    /**
     * @param InputInterface  $input
     * @param OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $logger = \Pimcore\Log\ApplicationLogger::getInstance("DatenAngebotCommand", true);

        $allPublishedOffers = VtoursDatenAngebot::getList(['unpublished' => false]);

        $allPublishedOffers->load();

        $allOfferObjects = $allPublishedOffers->objects;
        $errorCount = 0;
        /**
         * @var VtoursDatenAngebot $offerObject
         */
        foreach ($allOfferObjects as $offerObject) {
            //init container
            $startupContainerBuilder = new StartupContainerBuilder();
            $container = $startupContainerBuilder->build();
            $factory = $container->get('vtours.tt_xml_web_service.service.factory');

            $updateOffer = new UpdateOffer();
            try {
                $updateOffer->updateObject($offerObject, $factory);
                $offerObject->save();
            } catch (ValidationException $exception) {
                $errorCount++;
                $logger->alert('WARNING: an error occured while updating offer ' . $offerObject->getKey());
                $offerObject->setPublished(false);
                $offerObject->save();
            }
        }
        $logger->log("info", 'RESULT:' . (count($allOfferObjects) - $errorCount) . ' of ' . count($allOfferObjects) . ' offers successfully updated');
    }
}
