<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace TraveltainmentApi\Action;

use TraveltainmentApi\Exception\FolderNotFoundException;
use TraveltainmentApi\Helper\Folder;
use TraveltainmentApi\Model\DatenRegionModel;
use TraveltainmentApi\WebService\TraveltainmentApiService;
use Vtours\TTXmlWebService\Model\Response\V2\InventoryDataForPackageRS;
use Vtours\TTXmlWebService\Service\Factory;

class UpdateRegion
{

    /**
     * @var TraveltainmentApiService $traveltainmentApiService
     */
    private $traveltainmentApiService;
    /**
     * @var DatenRegionModel $datenRegionModel
     */
    private $datenRegionModel;


    public function __construct()
    {
        $this->traveltainmentApiService = new TraveltainmentApiService();
        $this->datenRegionModel = new DatenRegionModel();
    }


    public function getCompleteRegionTree(Factory $factory)
    {
        $regionTreeResponse = $this->traveltainmentApiService->getCompleteRegionTree($factory->regionTree());

        $allRegions = $regionTreeResponse->getRegions();

        if ($allRegions->getSubRegions() !== null) {
            try {
                $allSubRegions = $allRegions->getSubRegions();
                $folder = (new Folder())->getFolder();
                $this->datenRegionModel->getSubRegions($allSubRegions, $folder);
            } catch (FolderNotFoundException $e) {
                return $e;
            }
        }
        return true;
    }

    public function getCompleteRegionTreeV2(Factory $factory)
    {
        /**
         * @var InventoryDataForPackageRS $regionTreeResponse
         */
        $regionTreeResponse = $this->traveltainmentApiService->getCompleteRegionTreeV2($factory->regionTree());

        $allRegions = $regionTreeResponse->getInventoryDataForPackageRS()->getRegionGroups()->getRegionGroup();

        if ($allRegions !== null) {
            try {
                $folder = (new Folder())->getFolder();
                $this->datenRegionModel->getSubRegionsV2($allRegions, $folder);
            } catch (FolderNotFoundException $e) {
                return $e;
            }
        }
        return true;
    }
}
