<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace TraveltainmentApi\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use TraveltainmentApi\Action\UpdateRegion;
use TraveltainmentApi\Exception\FolderNotFoundException;
use Vtours\TTXmlWebService\DependencyInjection\StartupContainerBuilder\StartupContainerBuilder;
use Vtours\TTXmlWebService\Service\Factory;

/**
 * Class RegionTreeCommand
 *
 * @package TraveltainmentApi\Command
 */
class RegionTreeCommand extends AbstractCommand
{
    /**
     * configure
     */
    protected function configure()
    {
        $this
            ->setName('vtours:tt:region')
            ->setDescription('create region tree');
    }

    /**
     * @param InputInterface  $input
     * @param OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $logger = \Pimcore\Log\ApplicationLogger::getInstance("RegionTreeCommand", true);
        $startupContainerBuilder = new StartupContainerBuilder();
        $container = $startupContainerBuilder->build();
        /** @var Factory $factory */
        $factory = $container->get('vtours.tt_xml_web_service.service.factory');

        try {
            $updateRegion = new UpdateRegion();
            $updateRegion->getCompleteRegionTree($factory);
        } catch (FolderNotFoundException $e) {
            $logger->alert('Error while creating region tree:' . $e->getMessage());
        }
        $logger->log("info", 'RESULT: regiontree updated successfully');
    }
}
