<?php

namespace TraveltainmentApi\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use TraveltainmentApi\Action\UpdateRegion;
use TraveltainmentApi\Exception\FolderNotFoundException;
use Vtours\TTXmlWebService\DependencyInjection\StartupContainerBuilder\StartupContainerBuilder;
use Vtours\TTXmlWebService\Service\Factory;

/**
 * Class RegionTreeCommandV2
 *
 * @package TraveltainmentApi\Command
 */
class RegionTreeCommandV2 extends AbstractCommand
{

    /**
     * configure
     */
    protected function configure()
    {
        $this
            ->setName('vtours:tt:regionv2')
            ->setDescription('create region tree v2');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $logger = \Pimcore\Log\ApplicationLogger::getInstance("RegionTreeCommandV2", true);
        $startupContainerBuilder = new StartupContainerBuilder();
        $container = $startupContainerBuilder->build();
        /** @var Factory $factory */
        $factory = $container->get('vtours.tt_xml_web_service.service.factory');

        try {
            $updateRegion = new UpdateRegion();
            $updateRegion->getCompleteRegionTreeV2($factory);
        } catch (FolderNotFoundException $e) {
            $logger->alert('Error while creating region tree:' . $e->getMessage());
        }
        $logger->log("info", 'RESULT: regiontree updated successfully');
    }

}
