<?php

namespace TraveltainmentApi\Model;

use Pimcore\File;
use Pimcore\Model\Asset;
use Pimcore\Model\Element\ValidationException;
use Pimcore\Model\Object\Data\QuantityValue;
use Pimcore\Model\Object\QuantityValue\Unit;
use Pimcore\Model\Object\VtoursDatenAngebot;
use Vtours\TTXmlWebService\Model\DatenAngebotResponseModel;

/**
 * Class DatenAngebotModel
 *
 * @package TraveltainmentApi\Model
 */
class DatenAngebotModel
{

    /**
     * @param VtoursDatenAngebot        $object
     * @param DatenAngebotResponseModel $responseModel
     *
     * @return VtoursDatenAngebot
     * @throws ValidationException
     */
    public function mapObject(VtoursDatenAngebot $object, DatenAngebotResponseModel $responseModel)
    {
        $object->setHotelName((string)$responseModel->getHotelName());
        $object->setLocation($responseModel->getHotelRegion());
        $object->setCountry($responseModel->getHotelCountry());
        $object->setCategory($responseModel->getHotelStars());
        $object->setLocationID($responseModel->getHotelCityId());

        $this->mapImage($object, $responseModel->getHotelPictureUrl());

        $object->setMaxTemperature($responseModel->getRegionTemperature());

        $price = $responseModel->getOfferPrice();

        $unit = Unit::getByAbbreviation($responseModel->getOfferPriceCurrency());

        if ($unit == null) {
            throw new ValidationException('quantity value not available');
        }

        $priceObject = new QuantityValue($price, $unit->getId());

        $object->setPrice($priceObject);

        $object->setOfferID($responseModel->getOfferId());

        $object->setMeal($responseModel->getOfferMealType());
        $object->setDuration($responseModel->getOfferTravelDuration());
        $object->setRoom($responseModel->getOfferRoomType());

        $object->setFlight($responseModel->isOfferWithFlight());
        $object->setTransfer($responseModel->isOfferWithTransfer());
        if ($responseModel->getOfferDepartureAirport()) {
            $object->setDepartureAirport($responseModel->getOfferDepartureAirport());
        }

        $deeplinkObject = new \Pimcore\Model\Object\Data\Link();
        $deeplink = $responseModel->getDeeplinkPrefix() . $responseModel->getDeeplinkParameter();
        $deeplinkParameters = $responseModel->getDeeplinkParameter();
        $deeplinkPrefix = $responseModel->getDeeplinkPrefix();
        $deeplinkObject->setParameters($deeplinkParameters);
        $deeplinkObject->setPath(substr($deeplinkPrefix, 0, strlen($deeplinkPrefix) - 1));
        $deeplinkObject->setText($deeplink);

        $object->setDeepLink($deeplinkObject);

        return $object;
    }

    /**
     * mapImage
     *
     * @param VtoursDatenAngebot $object
     * @param                    $imagePath
     */
    public function mapImage(VtoursDatenAngebot $object, $imagePath)
    {

        $fileName = (File::getValidFilename(substr($imagePath, strrpos($imagePath, '/') + 1)));

        $asset = Asset::getByPath("/vtours.de/daten/angebote/" . $fileName);
        if ($asset == null) {
            $newAsset = new Asset();
            $newAsset->setFilename($fileName);
            $newAsset->setData(file_get_contents($imagePath));
            $newAsset->setParent(Asset::getByPath("/vtours.de/daten/angebote/"));
            $newAsset->save();
        } else {
            $asset->setData(file_get_contents($imagePath));
            $asset->save();
        }

        /**
         * yes we need to get it again
         */
        $asset = Asset::getByPath('/vtours.de/daten/angebote/' . $fileName);
        $object->setHotelPicture($asset);
    }
}
