<?php

namespace TraveltainmentApi;

use Pimcore\API\Plugin as PluginLib;
use Pimcore\Console\AbstractConsoleCommandPlugin;
use Pimcore\Log\ApplicationLogger;
use Pimcore\Model\Object\VtoursDatenAngebot;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\VarDumper\Cloner\VarCloner;
use Symfony\Component\VarDumper\Dumper\CliDumper;
use Symfony\Component\VarDumper\VarDumper;
use TraveltainmentApi\Action\UpdateOffer;
use Vtours\TTXmlWebService\DependencyInjection\StartupContainerBuilder\StartupContainerBuilder;

/**
 * Class Plugin
 *
 *
 * @package TraveltainmentApi
 */
class Plugin extends AbstractConsoleCommandPlugin implements PluginLib\PluginInterface
{

    /**
     * Returns an array of commands to be added to the application.
     * To be implemented by plugin classes providing console commands.
     *
     * @return Command[]
     */
    public function getConsoleCommands()
    {
        return [
            new \TraveltainmentApi\Command\RegionTreeCommand(),
            new \TraveltainmentApi\Command\RegionTreeCommandV2(),
            new \TraveltainmentApi\Command\DatenAngebotCommand(),
            new \TraveltainmentApi\Command\DatenAngebotCommandV2(),
        ];
    }

    /**
     * init
     */
    public function init()
    {
        parent::init();

        $logger = ApplicationLogger::getInstance('TraveltainmentApi', true);
        $this->initDump($logger);

        \Pimcore::getEventManager()->attach(['object.preUpdate'], function (\Zend_EventManager_Event $event) {
            $object = $event->getTarget();

            if ($object instanceof VtoursDatenAngebot && $object->isPublished()) {
                /**
                 * @var ContainerBuilder $container
                 */
                $c = new StartupContainerBuilder();
                $container = $c->build();

                $update = new UpdateOffer();
                $update->updateObject($object, $container->get('vtours.tt_xml_web_service.service.factory'));
            }
        });
    }

    /**
     * initDump
     *
     * @param ApplicationLogger $logger
     */
    private function initDump(ApplicationLogger $logger)
    {

        VarDumper::setHandler(function ($var) use ($logger) {

            $cloner = new VarCloner();
            $dumper = new CliDumper();
            $output = fopen('php://memory', 'r+b');

            $dumper->dump($cloner->cloneVar($var), $output);
            $logger->debug(stream_get_contents($output, -1, 0));
        });
    }

    /**
     * install
     *
     * @return bool
     */
    public static function install()
    {
        // implement your own logic here
        return true;
    }

    /**
     * uninstall
     *
     * @return bool
     */
    public static function uninstall()
    {
        // implement your own logic here
        return true;
    }

    /**
     * isInstalled
     *
     * @return bool
     */
    public static function isInstalled()
    {
        // implement your own logic here
        return true;
    }
}
