<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Test\TraveltainmentApi;

use PHPUnit\Framework\TestCase;
use TraveltainmentApi\WebService\TraveltainmentApiService;
use Vtours\TTXmlWebService\Model\DatenAngebotRequestModel;
use Vtours\TTXmlWebService\Model\Response\Accommodation;
use Vtours\TTXmlWebService\Model\Response\Category;
use Vtours\TTXmlWebService\Model\Response\City;
use Vtours\TTXmlWebService\Model\Response\Hotel;
use Vtours\TTXmlWebService\Model\Response\Meal;
use Vtours\TTXmlWebService\Model\Response\ObjectImages;
use Vtours\TTXmlWebService\Model\Response\Offer;
use Vtours\TTXmlWebService\Model\Response\Package;
use Vtours\TTXmlWebService\Model\Response\PriceResponse\OriginalPrice;
use Vtours\TTXmlWebService\Model\Response\PriceResponse\PriceInformation;
use Vtours\TTXmlWebService\Model\Response\Region;
use Vtours\TTXmlWebService\Model\Response\Room;

/**
 * Class TraveltainmentApiServiceTest
 * @package Test\TraveltainmentApi
 */
class TraveltainmentApiServiceTest extends TestCase
{
    /**
     * @var TraveltainmentApiService
     */
    private $ttApiService;

    /**
     * @var DatenAngebotRequestModel
     */
    private $requestModel;

    /**
     * @var Hotel
     */
    private $hotel;

    /**
     * @var Offer
     */
    private $offer;

    /**
     * @var Region
     */
    private $region;

    /**
     * @var Accommodation
     */
    private $accommodation;

    protected function setUp(): void
    {
        $this->ttApiService = new TraveltainmentApiService();
    }

    private function createMocksForTestingResponseModelMapping()
    {
        $this->requestModel = new DatenAngebotRequestModel();
        $this->requestModel
            ->setTraveldateStart(new \DateTime())
            ->setTraveldateEnd(new \DateTime())
            ->setTravellers([20, 25])
            ->setHotelAttributes([]);

        $priceInfo = new PriceInformation();
        $priceInfo->setOriginalPrice(new OriginalPrice());

        $this->offer = new Offer();
        $this->offer->setPriceInformation($priceInfo);

        $this->hotel = new Hotel();
        $this->hotel
            ->setCity(new City('unit_test', 0))
            ->setCategory(new Category(99, 99, 100))
            ->setObjectImages(new ObjectImages("thumbnail_mock", "medium_image_mock", "large_image_mock"));

        $this->region = new Region();

        $room = new Room("DZ", "UnitTest", 42, []);
        $this->accommodation = new Accommodation($room, [], 43, 1, true, []);
        $this->accommodation
            ->setMeal(new Meal())
            ->setCategory(44.5);
    }

    public function test_override_hotel_stars_with_accommodation_stars_when_tt_returns_valid_hotel_response()
    {
        $this->createMocksForTestingResponseModelMapping();

        $this->requestModel->setOffertype(TraveltainmentApiService::OFFER_TYPE_HOTEL);

        $this->offer->setAccommodation($this->accommodation);

        $responseModel = $this->ttApiService->createObjectData(
            $this->offer,
            $this->hotel,
            $this->region,
            $this->requestModel
        );

        $this->assertSame(44.5, $responseModel->getHotelStars());
    }

    public function test_override_hotel_stars_with_accommodation_stars_when_tt_returns_valid_package_response()
    {
        $this->createMocksForTestingResponseModelMapping();

        $this->requestModel->setOffertype(TraveltainmentApiService::OFFER_TYPE_PACKAGE);

        $package = new Package();
        $package->setAccommodation($this->accommodation);

        $this->offer->setPackage($package);

        $responseModel = $this->ttApiService->createObjectData(
            $this->offer,
            $this->hotel,
            $this->region,
            $this->requestModel
        );

        $this->assertSame(44.5, $responseModel->getHotelStars());
    }
}
