<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\FilterRequest\HotelReviewRequest;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class TravellerType
 *
 * @package Vtours\TTXmlWebService\Model\Request\FilterRequest\HotelReviewRequest
 */
class TravellerType
{
    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TravellerType")
     */
    private $travellerType;

    /**
     * TravellerType constructor.
     *
     * @param string $travellerType
     */
    public function __construct($travellerType)
    {
        $this->travellerType = $travellerType;
    }

    /**
     * @return string
     */
    public function getTravellerType()
    {
        return $this->travellerType;
    }

    /**
     * @param string $travellerType
     *
     * @return TravellerType
     */
    public function setTravellerType($travellerType)
    {
        $this->travellerType = $travellerType;

        return $this;
    }


}
