<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class PriceSpan
 *
 * @package Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest
 */
class PriceSpan
{
    /**
     * @var float
     * @Serializer\Type("float")
     * @Serializer\SerializedName("MinPrice")
     */
    private $minPrice;

    /**
     * @var float
     * @Serializer\Type("float")
     * @Serializer\SerializedName("MaxPrice")
     */
    private $maxPrice;


    /**
     * @return float
     */
    public function getMinPrice()
    {
        return $this->minPrice;
    }

    /**
     * @param float $minPrice
     *
     * @return PriceSpan
     */
    public function setMinPrice($minPrice)
    {
        $this->minPrice = $minPrice;

        return $this;
    }

    /**
     * @return float
     */
    public function getMaxPrice()
    {
        return $this->maxPrice;
    }

    /**
     * @param float $maxPrice
     *
     * @return PriceSpan
     */
    public function setMaxPrice($maxPrice)
    {
        $this->maxPrice = $maxPrice;

        return $this;
    }

}