<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\TravelDateRequest;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class TravelDateSpan
 *
 * @package Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest\JourneyRequest\TravelDateRequest
 */
class TravelDateSpan
{
    /**
     * @var \DateTime
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("DepartureDate")
     */
    private $departureDate;

    /**
     * @var \DateTime
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("ReturnDate")
     */
    private $returnDate;

    /**
     * TravelDateSpan constructor.
     *
     * @param \DateTime $departureDate
     * @param \DateTime $returnDate
     */
    public function __construct(\DateTime $departureDate, \DateTime $returnDate)
    {
        $this->departureDate = $departureDate;
        $this->returnDate = $returnDate;
    }

    /**
     * @return \DateTime
     */
    public function getDepartureDate()
    {
        return $this->departureDate;
    }

    /**
     * @param \DateTime $departureDate
     *
     * @return TravelDateSpan
     */
    public function setDepartureDate($departureDate)
    {
        $this->departureDate = $departureDate;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getReturnDate()
    {
        return $this->returnDate;
    }

    /**
     * @param \DateTime $returnDate
     *
     * @return TravelDateSpan
     */
    public function setReturnDate($returnDate)
    {
        $this->returnDate = $returnDate;

        return $this;
    }


}
