<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class TourOperator
 *
 * @package Vtours\TTXmlWebService\Model\Request\SearchRequest\TripRequest
 */
class TourOperator
{

    /**
     * @var string
     * @Serializer\XmlList(entry = "TourOperator")
     * @Serializer\SerializedName("limit")
     */
    private $limit;

    /**
     * @var string
     * @Serializer\XmlList(entry = "TourOperator")
     * @Serializer\SerializedName("skip")
     */
    private $skip;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("AccomCode")
     */
    private $accomMode;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("RoomCode")
     */
    private $roomCode;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TravelType")
     */
    private $travelType;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ProgramType")
     */
    private $programType;

    /**
     * @return string
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param string $limit
     *
     * @return TourOperator
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;

        return $this;
    }

    /**
     * @return string
     */
    public function getSkip()
    {
        return $this->skip;
    }

    /**
     * @param string $skip
     *
     * @return TourOperator
     */
    public function setSkip($skip)
    {
        $this->skip = $skip;

        return $this;
    }

    /**
     * @return string
     */
    public function getAccomMode()
    {
        return $this->accomMode;
    }

    /**
     * @param string $accomMode
     *
     * @return TourOperator
     */
    public function setAccomMode($accomMode)
    {
        $this->accomMode = $accomMode;

        return $this;
    }

    /**
     * @return string
     */
    public function getRoomCode()
    {
        return $this->roomCode;
    }

    /**
     * @param string $roomCode
     *
     * @return TourOperator
     */
    public function setRoomCode($roomCode)
    {
        $this->roomCode = $roomCode;

        return $this;
    }

    /**
     * @return string
     */
    public function getTravelType()
    {
        return $this->travelType;
    }

    /**
     * @param string $travelType
     *
     * @return TourOperator
     */
    public function setTravelType($travelType)
    {
        $this->travelType = $travelType;

        return $this;
    }

    /**
     * @return string
     */
    public function getProgramType()
    {
        return $this->programType;
    }

    /**
     * @param string $programType
     *
     * @return TourOperator
     */
    public function setProgramType($programType)
    {
        $this->programType = $programType;

        return $this;
    }
}
