<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\SelectionRequest;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class HotelSelection
 *
 * @package Vtours\TTXmlWebService\Model\Request
 */
class HotelSelection
{
    /**
     * @var int
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\SelectionRequest\ObjectId")
     * @Serializer\SerializedName("ObjectID")
     */
    private $objectId;


    public function __construct($objectId)
    {
        $this->objectId = new ObjectId($objectId);
    }
}
