<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("ListItem")
 *
 * @package Vtours\TTXmlWebService\Model\Response
 */
class ListItem
{
    /**
     * @var Region
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Region")
     * @Serializer\SerializedName("Region")
     */
    private $region;

    /**
     * @var Hotel
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Hotel")
     * @Serializer\SerializedName("Hotel")
     */
    private $hotel;

    /**
     * @var Offer
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Offer")
     * @Serializer\SerializedName("Offer")
     */
    private $offer;


    /**
     * ListItem constructor.
     *
     * @param Region $region
     * @param Hotel  $hotel
     * @param Offer  $offer
     */
    public function __construct(Region $region, Hotel $hotel, Offer $offer)
    {
        $this->region = $region;
        $this->hotel = $hotel;
        $this->offer = $offer;
    }

    /**
     * @return Region
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * @param Region $region
     *
     * @return ListItem
     */
    public function setRegion($region)
    {
        $this->region = $region;

        return $this;
    }

    /**
     * @return Hotel
     */
    public function getHotel()
    {
        return $this->hotel;
    }

    /**
     * @param Hotel $hotel
     *
     * @return ListItem
     */
    public function setHotel($hotel)
    {
        $this->hotel = $hotel;

        return $this;
    }

    /**
     * @return Offer
     */
    public function getOffer()
    {
        return $this->offer;
    }

    /**
     * @param Offer $offer
     *
     * @return ListItem
     */
    public function setOffer($offer)
    {
        $this->offer = $offer;

        return $this;
    }
}
