<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\RegionListResponse;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class SubRegion
 *
 * @package Vtours\TTXmlWebService\Model\Response\RegionListResponse
 */
class SubRegion
{
    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ID")
     */
    private $id;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("RegionName")
     */
    private $regionName;


    /**
     * @var array<SubRegion>
     * @Serializer\XmlList(entry ="SubRegion")
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\RegionListResponse\SubRegion>")
     * @Serializer\SerializedName("SubRegions")
     */
    private $subRegions;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     *
     * @return SubRegion
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function getRegionName()
    {
        return $this->regionName;
    }

    /**
     * @param string $regionName
     *
     * @return SubRegion
     */
    public function setRegionName($regionName)
    {
        $this->regionName = $regionName;

        return $this;
    }

    /**
     * @return array
     */
    public function getSubRegions()
    {
        return $this->subRegions;
    }

    /**
     * @param array $subRegions
     *
     * @return SubRegion
     */
    public function setSubRegions($subRegions)
    {
        $this->subRegions = $subRegions;

        return $this;
    }
}
