<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\WeatherResponse;


use JMS\Serializer\Annotation as Serializer;

/**
 * Class ClimaData
 *
 * @package Vtours\TTXmlWebService\Model\Response\WeatherResponse
 */
class ClimaData
{
    /**
     * @var array<YearOverview>
     * @Serializer\XmlList(inline = true, entry = "YearOverview")
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\WeatherResponse\YearOverview>")
     */
    private $yearOverview;

    /**
     * @return array
     */
    public function getYearOverview()
    {
        return $this->yearOverview;
    }

    /**
     * @param array $yearOverview
     *
     * @return ClimaData
     */
    public function setYearOverview($yearOverview)
    {
        $this->yearOverview = $yearOverview;

        return $this;
    }
}
