<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

use JMS\Serializer\Serializer;
use Vtours\TTXmlWebService\Service\TravelTainmentService;

/**
 * Created by PhpStorm.
 * User: j.kretz
 * Date: 05.07.2017
 * Time: 14:47
 */
class TravelTainmentServiceTest extends \PHPUnit\Framework\TestCase
{

    /**
     * @var Serializer
     */
    private $serializer;

    public function setUp()
    {
        $this->serializer = \JMS\Serializer\SerializerBuilder::create()->build();

    }

    public function testOfferByHotel()
    {
        $ttService = new TravelTainmentService();

        $hotelId = 32394; //giata
        $mealType = null;
        $durationDays = [2, 5];
        $durationPeriod = [];
        $type = 'Hotel'; //change to 'Hotel' for offers without flight

        $request = new \Vtours\TTXmlWebService\Model\Request\SearchEngineOfferListRQ($durationDays, $durationPeriod, $mealType, $hotelId);
        $requestxml = $this->serializer->serialize($request, 'xml');
        //echo $requestxml;

        /**
         * @var $response \GuzzleHttp\Psr7\Response
         */
        $response = $ttService->getAllHotelOffersByGiata($durationDays, $durationPeriod, $mealType, $hotelId, $type);
        //$obj = $response->getBody()->getContents();
        //echo $response;

        //$result = $this->serializer->deserialize($response, Vtours\TTXmlWebService\Model\Response\SearchEngineOfferListRS::class, 'xml');
        var_dump($response);

    }


    public function testGetBestOfferOfCity()
    {
        $this->markTestSkipped('skip offer city');

        $ttService = new TravelTainmentService();

        $cityId = [1732];
        $topRegionIds = [35];
        $mealType = 'BREAKFAST';
        $durationDays = [2, 5];

        $response = $ttService->getBestCityOffer($durationDays, $mealType, $cityId, $topRegionIds);
        $obj = $response->getBody()->getContents();

        /**
         * @var $result \Vtours\TTXmlWebService\Model\Response\SearchEngineCityListRS
         */
        $result = $this->serializer->deserialize($obj, Vtours\TTXmlWebService\Model\Response\SearchEngineCityListRS::class, 'xml');

//        /**
//         * @var $item \Vtours\TTXmlWebService\Model\Response\ListItem
//         */
//        $listitem = $result->getResultSet()->getListItem();
//        foreach ($listitem as $item) {
//            var_dump($result);
//            var_dump($item);
//            var_dump($item->getRegion()->getWeatherForRegion()->getClimaData());
//            $offer = $item->getOffer();
//            var_dump($offer);
//            }

//        var_dump($result);
    }

    public function testGetBestOfferByHotel()
    {
        $this->markTestSkipped('skip single offer by hotel');

        $ttService = new TravelTainmentService();
        $hotelId = 32394; //giata
//        $regionId = 106; // Berlin
        $duration = [4, 8];
        $mealType = 'BREAKFAST';

        $req = new \Vtours\TTXmlWebService\Model\Request\SearchEngineHotelListRQ($duration, $mealType, $hotelId, null);
        $xml = $this->serializer->serialize($req, 'xml');

        echo $xml;

        $response = $ttService->getBestPackageOfferByGiata($hotelId, $duration, $mealType);
        $obj = $response->getBody()->getContents();

        /**
         * @var $result \Vtours\TTXmlWebService\Model\Response\SearchEngineHotelListRS
         */
        $result = $this->serializer->deserialize($obj, Vtours\TTXmlWebService\Model\Response\SearchEngineHotelListRS::class, 'xml');

        /**
         * @var $item \Vtours\TTXmlWebService\Model\Response\ListItem
         */
        $listitem = $result->getResultSet()->getListItem();
        foreach ($listitem as $item) {
//            var_dump($item);
//            $offer = $item->getOffer();
//            var_dump($offer);
        }
//        echo $obj;
//        var_dump($result);
    }

    public function testGetRegionTree()
    {
        $this->markTestSkipped('skip region tree');

        $ttService = new TravelTainmentService();

        $response = $ttService->getRegionTree();
        $obj = $response->getBody()->getContents();
        /**
         * @var $result \Vtours\TTXmlWebService\Model\Response\RegionListResponse\SearchEngineRegionTreeRS
         */
        $result = $this->serializer->deserialize($obj, Vtours\TTXmlWebService\Model\Response\RegionListResponse\SearchEngineRegionTreeRS::class,
            'xml');

        $regions = $result->getRegions();
        $subregions = $regions->getSubRegions();
//        var_dump($regions);
        foreach ($subregions as $subregion) {
            var_dump($subregion);
            /**
             * @var $subregion \Vtours\TTXmlWebService\Model\Response\RegionListResponse\SubRegion
             */
            foreach ($subregion->getSubRegions() as $subreg) {
                var_dump($subreg);
            }
        }

//        echo $obj;
//        var_dump($result);

    }

    public function testGetBestHotelOfferByRegion()
    {
        $this->markTestSkipped('skip single offer by hotel');

        $ttService = new TravelTainmentService();
        $regionId = 106; // Berlin
        $duration = [4, 8];
        $mealType = 'BREAKFAST';

        $response = $ttService->getBestHotelOffersByRegion($duration, $mealType, $regionId);
        $obj = $response->getBody()->getContents();

        /**
         * @var $result \Vtours\TTXmlWebService\Model\Response\SearchEngineCityListRS
         */
        $result = $this->serializer->deserialize($obj, Vtours\TTXmlWebService\Model\Response\SearchEngineHotelListRS::class, 'xml');

        /**
         * @var $item \Vtours\TTXmlWebService\Model\Response\ListItem
         */
        $listitem = $result->getResultSet()->getListItem();
        foreach ($listitem as $item) {
//            var_dump($item);
//            $offer = $item->getOffer();
//            var_dump($offer);
        }
//        echo $obj;
//        var_dump($result);
    }

}